/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.deploy.providers;

import org.cipango.server.session.SessionManager;
import org.cipango.server.sipapp.SipAppContext;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.providers.WebAppProvider;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.webapp.WebAppContext;

public class SipAppProvider
extends WebAppProvider {
    private String _defaultsSipDescriptor;
    private String _sessionManagerClass;

    public ContextHandler createContextHandler(App app) throws Exception {
        WebAppContext context = (WebAppContext)super.createContextHandler(app);
        SipAppContext sipAppContext = new SipAppContext();
        sipAppContext.setWebAppContext(context, true);
        context.addBean((Object)sipAppContext);
        if (this._defaultsSipDescriptor != null) {
            sipAppContext.setDefaultsDescriptor(this._defaultsSipDescriptor);
        }
        if (this._sessionManagerClass != null) {
            try {
                Class<?> clazz = Class.forName(this._sessionManagerClass);
                if (!SessionManager.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("Class " + this._sessionManagerClass + " is does not extends " + SessionManager.class.getName());
                }
                SessionManager sessionManager = (SessionManager)clazz.newInstance();
                sipAppContext.getSessionHandler().setSessionManager(sessionManager);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Failed to use class " + this._sessionManagerClass + " as session manager", e);
            }
        }
        return context;
    }

    public String getDefaultsSipDescriptor() {
        return this._defaultsSipDescriptor;
    }

    public void setDefaultsSipDescriptor(String defaultsSipDescriptor) {
        this._defaultsSipDescriptor = defaultsSipDescriptor;
    }

    public String getSessionManagerClass() {
        return this._sessionManagerClass;
    }

    public void setSessionManagerClass(String sessionManagerClass) {
        this._sessionManagerClass = sessionManagerClass;
    }
}

