/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.deploy.providers;

import java.io.File;
import org.cipango.sipapp.SipAppContext;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.providers.WebAppProvider;
import org.eclipse.jetty.deploy.util.FileID;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.resource.Resource;

public class SipAppProvider
extends WebAppProvider {
    private String _defaultsSipDescriptor;

    public ContextHandler createContextHandler(App app) throws Exception {
        Resource resource = Resource.newResource((String)app.getOriginId());
        File file = resource.getFile();
        if (!resource.exists()) {
            throw new IllegalStateException("App resouce does not exist " + resource);
        }
        String context = file.getName();
        if (!file.isDirectory()) {
            if (FileID.isWebArchiveFile((File)file)) {
                context = context.substring(0, context.length() - 4);
            } else {
                throw new IllegalStateException("unable to create ContextHandler for " + app);
            }
        }
        if (context.equalsIgnoreCase("root") || context.equalsIgnoreCase("root/")) {
            context = "/";
        }
        if (context.charAt(0) != '/') {
            context = "/" + context;
        }
        if (context.endsWith("/") && context.length() > 0) {
            context = context.substring(0, context.length() - 1);
        }
        SipAppContext sac = new SipAppContext();
        sac.setContextPath(context);
        sac.setWar(file.getAbsolutePath());
        if (this.getDefaultsDescriptor() != null) {
            sac.setDefaultsDescriptor(this.getDefaultsDescriptor());
        }
        if (this.getDefaultsSipDescriptor() != null) {
            sac.setDefaultsSipDescriptor(this.getDefaultsSipDescriptor());
        }
        sac.setExtractWAR(this.isExtractWars());
        sac.setParentLoaderPriority(this.isParentLoaderPriority());
        if (this.getConfigurationClasses() != null) {
            sac.setConfigurationClasses(this.getConfigurationClasses());
        }
        if (this.getTempDir() != null) {
            sac.setAttribute("org.eclipse.jetty.webapp.basetempdir", (Object)this.getTempDir());
        }
        return sac;
    }

    public String getDefaultsSipDescriptor() {
        return this._defaultsSipDescriptor;
    }

    public void setDefaultsSipDescriptor(String defaultsSipDescriptor) {
        this._defaultsSipDescriptor = defaultsSipDescriptor;
    }
}

