/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.deploy;

import java.util.ArrayList;
import org.cipango.sipapp.SipAppContext;
import org.eclipse.jetty.deploy.WebAppDeployer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.resource.Resource;

public class SipAppDeployer
extends WebAppDeployer {
    private ArrayList<SipAppContext> _deployed;
    private String _defaultsSipDescriptor;

    public void doStart() throws Exception {
        this._deployed = new ArrayList();
        this.scan();
    }

    public String getDefaultsSipDescriptor() {
        return this._defaultsSipDescriptor;
    }

    public void setDefaultsSipDescriptor(String defaultsDescriptor) {
        this._defaultsSipDescriptor = defaultsDescriptor;
    }

    public void scan() throws Exception {
        MultiException mex = new MultiException();
        if (this.getContexts() == null) {
            throw new IllegalArgumentException("No HandlerContainer");
        }
        Resource r = Resource.newResource((String)this.getWebAppDir());
        if (!r.exists()) {
            throw new IllegalArgumentException("No such sipapps resource " + r);
        }
        if (!r.isDirectory()) {
            throw new IllegalArgumentException("Not directory sipapps resource " + r);
        }
        String[] files = r.list();
        block4: for (int f = 0; files != null && f < files.length; ++f) {
            try {
                Resource unpacked;
                String context = files[f];
                if (context.equalsIgnoreCase("CVS/") || context.equalsIgnoreCase("CVS") || context.startsWith(".")) continue;
                Resource app = r.addPath(r.encode(context));
                if (!context.toLowerCase().endsWith(".war") && !context.toLowerCase().endsWith(".jar") && !context.toLowerCase().endsWith(".sar") ? !app.isDirectory() : (unpacked = r.addPath(context = context.substring(0, context.length() - 4))) != null && unpacked.exists() && unpacked.isDirectory()) continue;
                context = context.equalsIgnoreCase("root") || context.equalsIgnoreCase("root/") ? "/" : "/" + context;
                if (context.endsWith("/") && context.length() > 0) {
                    context = context.substring(0, context.length() - 1);
                }
                if (!this.getAllowDuplicates()) {
                    Handler[] installed = this.getContexts().getChildHandlersByClass(ContextHandler.class);
                    for (int i = 0; i < installed.length; ++i) {
                        SipAppContext sipAppContext;
                        ContextHandler c = (ContextHandler)installed[i];
                        if (c instanceof SipAppContext && context.equals((sipAppContext = (SipAppContext)c).getContextPath()) || context.equals(c.getContextPath()) || c.getBaseResource() != null && c.getBaseResource().getFile().getAbsolutePath().equals(app.getFile().getAbsolutePath())) continue block4;
                    }
                }
                SipAppContext sac = null;
                if (this.getContexts() instanceof ContextHandlerCollection && SipAppContext.class.isAssignableFrom(((ContextHandlerCollection)this.getContexts()).getContextClass())) {
                    try {
                        sac = (SipAppContext)((ContextHandlerCollection)this.getContexts()).getContextClass().newInstance();
                    }
                    catch (Exception e) {
                        throw new Error(e);
                    }
                } else {
                    sac = new SipAppContext();
                }
                sac.setContextPath(context);
                if (this.getConfigurationClasses() != null) {
                    sac.setConfigurationClasses(this.getConfigurationClasses());
                }
                if (this.getDefaultsDescriptor() != null) {
                    sac.setDefaultsDescriptor(this.getDefaultsDescriptor());
                }
                if (this.getDefaultsSipDescriptor() != null) {
                    sac.setDefaultsSipDescriptor(this.getDefaultsSipDescriptor());
                }
                sac.setExtractWAR(this.isExtract());
                sac.setWar(app.toString());
                sac.setParentLoaderPriority(this.isParentLoaderPriority());
                this.getContexts().addHandler((Handler)sac);
                this._deployed.add(sac);
                if (!this.getContexts().isStarted()) continue;
                this.getContexts().start();
                continue;
            }
            catch (Throwable e) {
                mex.add(e);
            }
        }
        mex.ifExceptionThrow();
    }

    public void doStop() throws Exception {
        MultiException mex = new MultiException();
        int i = this._deployed.size();
        while (i-- > 0) {
            ContextHandler wac = (ContextHandler)this._deployed.get(i);
            try {
                wac.stop();
            }
            catch (Throwable e) {
                mex.add(e);
            }
        }
        mex.ifExceptionThrow();
    }
}

