/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console.util;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PrinterUtil {
    public static final String PARAMS_POSTFIX = ".params";
    public static final ResourceBundle PARAMETERS = ResourceBundle.getBundle("org.cipango.console.methods");
    public static final ResourceBundle DESCRIPTION = ResourceBundle.getBundle("org.cipango.console.description");

    public static String[] getParams(String name) {
        return PrinterUtil.getValueSplit(name + PARAMS_POSTFIX);
    }

    private static String[] getValueSplit(String name) {
        try {
            return PARAMETERS.getString(name).split("\\p{Space}*,\\p{Space}*");
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static String getTitle(String name) {
        try {
            return PARAMETERS.getString(name + ".title").trim();
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static String getNote(String propertyName, String param) {
        try {
            return DESCRIPTION.getString(propertyName + ".params." + param).trim();
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static String getDuration(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        StringBuilder sb = new StringBuilder();
        if (days >= 1L) {
            sb.append(days).append(" day");
            if (days >= 1L) {
                sb.append('s');
            }
            sb.append(", ");
        }
        if (hours >= 1L) {
            sb.append(hours % 24L).append(" hour");
            if (hours % 24L > 1L) {
                sb.append('s');
            }
            sb.append(", ");
        }
        if (minutes >= 1L) {
            sb.append(minutes % 60L).append(" minute");
            if (minutes % 60L > 1L) {
                sb.append('s');
            }
            sb.append(", ");
        }
        sb.append(seconds % 60L).append(" second");
        if (seconds % 60L > 1L) {
            sb.append('s');
        }
        return sb.toString();
    }
}

