/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;

public class ConsoleUtil {
    public static String getParamValue(String name, HttpServletRequest request) {
        String val = request.getParameter(name);
        if (val == null) {
            return (String)request.getSession().getAttribute(name);
        }
        request.getSession().setAttribute(name, (Object)val);
        return val;
    }

    public static int getParamValueAsInt(String name, HttpServletRequest request, int defaultVal) {
        String val = request.getParameter(name);
        if (val == null) {
            Integer intVal = (Integer)request.getSession().getAttribute(name);
            return intVal == null ? defaultVal : intVal;
        }
        try {
            int intVal = Integer.parseInt(val);
            request.getSession().setAttribute(name, (Object)intVal);
            return intVal;
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public static Map<String, String> getFilters(ResourceBundle bundle) {
        HashMap<String, String> filters = new HashMap<String, String>();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.endsWith(".title")) continue;
            String title = bundle.getString(key);
            String prefix = key.substring(0, key.length() - ".title".length());
            String filter = bundle.getString(prefix + ".filter").trim();
            filters.put(filter, title);
        }
        return filters;
    }
}

