/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console.menu;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.cipango.console.menu.Page;

public class PageImpl
implements Page {
    private List<PageImpl> _pages = new ArrayList<PageImpl>();
    private PageImpl _father;
    private String _name;
    private String _title;
    private String _menuTitle;
    private ObjectName _objectName;

    public PageImpl(String title) {
        this._title = title;
    }

    public PageImpl(String name, String title) {
        this._name = name;
        this._title = title;
    }

    public PageImpl(String name, String title, String menuTitle) {
        this._name = name;
        this._title = title;
        this._menuTitle = menuTitle;
    }

    public List<PageImpl> getPages() {
        return this._pages;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getTitle() {
        if (this._title != null) {
            return this._title;
        }
        return this._name.substring(0, 1).toUpperCase() + this._name.substring(1);
    }

    public String getMenuTitle() {
        if (this._menuTitle != null) {
            return this._menuTitle;
        }
        return this.getTitle();
    }

    public PageImpl add(PageImpl page) {
        this._pages.add(page);
        page.setFather(this);
        return page;
    }

    public PageImpl getFather() {
        return this._father;
    }

    private void setFather(PageImpl father) {
        this._father = father;
    }

    @Override
    public boolean isDynamic() {
        return this._objectName != null;
    }

    public void setObjectName(ObjectName objectName) {
        this._objectName = objectName;
    }

    @Override
    public ObjectName getObjectName() {
        return this._objectName;
    }

    @Override
    public boolean isEnabled(MBeanServerConnection c) throws IOException {
        return true;
    }
}

