/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console.menu;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServerConnection;
import org.cipango.console.ApplicationManager;
import org.cipango.console.DiameterManager;
import org.cipango.console.EnvManager;
import org.cipango.console.JettyManager;
import org.cipango.console.SipManager;
import org.cipango.console.SnmpManager;
import org.cipango.console.menu.Menu;
import org.cipango.console.menu.Page;
import org.cipango.console.menu.PageImpl;
import org.cipango.console.util.ObjectNameFactory;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class MenuImpl
implements Menu {
    private static final PageImpl PAGES = new PageImpl("");
    public static final PageImpl SERVER = PAGES.add(new PageImpl("Server"));
    public static final PageImpl ABOUT = SERVER.add(new PageImpl("about.vm", "About"));
    public static final PageImpl SYSTEM_PROPERTIES = SERVER.add(new PageImpl("system-properties.vm", "System Properties"));
    public static final PageImpl CONFIG = PAGES.add(new PageImpl("Configuration"));
    public static final PageImpl CONFIG_SIP = CONFIG.add(new PageImpl("configuration/sip.vm", "SIP Configuration", "SIP"){

        @Override
        public boolean isEnabled(MBeanServerConnection c) throws IOException {
            return c.isRegistered(SipManager.SERVER);
        }
    });
    public static final PageImpl CONFIG_HTTP = CONFIG.add(new PageImpl("configuration/http.vm", "HTTP Configuration", "HTTP"));
    public static final PageImpl CONFIG_DIAMETER = CONFIG.add(new PageImpl("configuration/diameter.vm", "Diameter Configuration", "Diameter"){

        @Override
        public boolean isEnabled(MBeanServerConnection c) throws IOException {
            return c.isRegistered(DiameterManager.NODE);
        }
    });
    public static final PageImpl CONFIG_SNMP = CONFIG.add(new PageImpl("configuration/snmp.vm", "SNMP Configuration", "SNMP"){

        @Override
        public boolean isEnabled(MBeanServerConnection c) throws IOException {
            return c.isRegistered(SnmpManager.AGENT);
        }
    });
    public static final PageImpl APPLICATIONS = PAGES.add(new PageImpl("Applications"){

        @Override
        public boolean isEnabled(MBeanServerConnection c) throws IOException {
            return !c.isRegistered(ObjectNameFactory.create("org.cipango.console:page-disabled=application"));
        }
    });
    public static final PageImpl MAPPINGS = APPLICATIONS.add(new PageImpl("applications.vm", "Applications Mapping"){

        @Override
        public boolean isEnabled(MBeanServerConnection c) throws IOException {
            return this.getFather().isEnabled(c);
        }
    });
    public static final PageImpl DAR = APPLICATIONS.add(new PageImpl("dar.vm", "Default Application Router", "DAR"){

        @Override
        public boolean isEnabled(MBeanServerConnection c) throws IOException {
            return this.getFather().isEnabled(c) && c.isRegistered(ApplicationManager.DAR);
        }
    });
    public static final PageImpl STATISTICS = PAGES.add(new PageImpl("Statistics"));
    public static final PageImpl STATISTICS_SIP = STATISTICS.add(new PageImpl("statistics/sip.vm", "SIP Statistics", "SIP"));
    public static final PageImpl STATISTICS_HTTP = STATISTICS.add(new PageImpl("statistics/http.vm", "HTTP Statistics", "HTTP"){

        @Override
        public boolean isEnabled(MBeanServerConnection c) throws IOException {
            return false;
        }
    });
    public static final PageImpl STATISTICS_DIAMETER = STATISTICS.add(new PageImpl("statistics/diameter.vm", "Diameter Statistics", "Diameter"){

        @Override
        public boolean isEnabled(MBeanServerConnection c) throws IOException {
            return c.isRegistered(DiameterManager.NODE);
        }
    });
    public static final PageImpl STATISTICS_GRAPH = STATISTICS.add(new PageImpl("statistics/graph.vm", "Statistics graphs", "Graphs"));
    public static final PageImpl LOGS = PAGES.add(new PageImpl("Logs"));
    public static final PageImpl SIP_LOGS = LOGS.add(new PageImpl("logs/sip.vm", "SIP Logs", "SIP"){

        @Override
        public boolean isEnabled(MBeanServerConnection c) throws IOException {
            return c.isRegistered(SipManager.CONSOLE_LOGGER) || c.isRegistered(SipManager.FILE_MESSAGE_LOG);
        }
    });
    public static final PageImpl HTTP_LOGS = LOGS.add(new PageImpl("logs/http.vm", "HTTP Logs", "HTTP"){

        @Override
        public boolean isEnabled(MBeanServerConnection c) throws IOException {
            return c.isRegistered(JettyManager.HTTP_LOG);
        }
    });
    public static final PageImpl DIAMETER_LOGS = LOGS.add(new PageImpl("logs/diameter.vm", "Diameter Logs", "Diameter"){

        @Override
        public boolean isEnabled(MBeanServerConnection c) throws IOException {
            return c.isRegistered(DiameterManager.NODE);
        }
    });
    public static final PageImpl CALLS = LOGS.add(new PageImpl("logs/sessions.vm", "Sessions"));
    public static final PageImpl REPLICATED_SESSION = LOGS.add(new PageImpl("logs/replicated-sessions.vm", "Replicated sessions"));
    public static final PageImpl SYSTEM_LOGS = LOGS.add(new PageImpl("logs/systems.vm", "System logs"){

        @Override
        public boolean isEnabled(MBeanServerConnection c) throws IOException {
            return c.isRegistered(EnvManager.LOGBACK) || c.isRegistered(EnvManager.JETTY_LOGGER);
        }
    });
    protected MBeanServerConnection _connection;
    protected PageImpl _currentPage;
    protected List<PageImpl> _pages;
    private static Logger _logger = Log.getLogger(MenuImpl.class);

    public MenuImpl(MBeanServerConnection c, String command) {
        this._connection = c;
        this._pages = this.getPages();
        Iterator<PageImpl> it = this._pages.iterator();
        while (it.hasNext()) {
            PageImpl subPage = this.getPage(command, it.next());
            if (subPage == null) continue;
            this._currentPage = subPage;
            break;
        }
    }

    private PageImpl getPage(String command, PageImpl page) {
        Iterator<PageImpl> it = page.getPages().iterator();
        while (it.hasNext()) {
            PageImpl subPage = this.getPage(command, it.next());
            if (subPage == null) continue;
            return subPage;
        }
        if (command != null && command.equals(page.getName())) {
            return page;
        }
        return null;
    }

    @Override
    public Page getCurrentPage() {
        return this._currentPage;
    }

    @Override
    public String getTitle() {
        return this._currentPage == null ? "Cipango console" : this._currentPage.getTitle();
    }

    @Override
    public String getHtmlTitle() {
        if (this._currentPage.getFather() == null) {
            return "<h1>" + this._currentPage.getTitle() + "</h1>\n";
        }
        return "<h1>" + this._currentPage.getFather().getTitle() + "<span> > " + this._currentPage.getMenuTitle() + "</span></h1>\n";
    }

    public boolean isPageEnabled(PageImpl page) throws IOException {
        return page.isEnabled(this._connection);
    }

    public boolean isCurrentPage(PageImpl page) {
        return this._currentPage != null && (page == this._currentPage || page == this._currentPage.getFather());
    }

    public List<PageImpl> getPages() {
        return PAGES.getPages();
    }
}

