/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console.data;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.cipango.console.data.Row;
import org.cipango.console.util.PrinterUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Table
extends AbstractList<Row> {
    private static Logger __logger = Log.getLogger(Table.class);
    private List<Row> _rows = new ArrayList<Row>();
    private List<Row.Header> _headers;
    private String _title;

    public Table() {
    }

    public Table(MBeanServerConnection connection, Set<ObjectName> objectNameSet, String propertyName) throws Exception {
        List<Row.Header> headers = this.getHeaders(connection, objectNameSet, propertyName);
        this.setTitle(PrinterUtil.getTitle(propertyName));
        this.setHeaders(headers);
        if (objectNameSet != null) {
            for (ObjectName objectName : objectNameSet) {
                Row row = new Row();
                List<Row.Value> values = row.getValues();
                for (Row.Header header : headers) {
                    values.add(this.getValue(connection, objectName, header));
                }
                row.setObjectName(objectName);
                this.add(row);
            }
        }
    }

    protected Row.Value getValue(MBeanServerConnection connection, ObjectName objectName, Row.Header header) throws Exception {
        return new Row.Value(connection.getAttribute(objectName, header.getSimpleName()), header);
    }

    public Table(MBeanServerConnection connection, ObjectName[] objectNames, String propertyName) throws Exception {
        this(connection, new HashSet<ObjectName>(Arrays.asList(objectNames)), propertyName);
    }

    public List<Row.Header> getHeaders(MBeanServerConnection connection, Set<ObjectName> objectNameSet, String propertyName) throws Exception {
        ObjectName objectName = null;
        if (objectNameSet != null && !objectNameSet.isEmpty()) {
            objectName = objectNameSet.iterator().next();
        }
        return this.getHeaders(connection, objectName, propertyName);
    }

    public List<Row.Header> getHeaders(MBeanServerConnection connection, ObjectName objectName, String propertyName) throws Exception {
        String[] params = PrinterUtil.getParams(propertyName);
        ArrayList<Row.Header> headers = new ArrayList<Row.Header>();
        if (objectName == null) {
            for (String param : params) {
                headers.add(new Row.Header(param, param));
            }
        } else {
            MBeanInfo info = connection.getMBeanInfo(objectName);
            MBeanAttributeInfo[] attrInfos = info.getAttributes();
            for (String param : params) {
                Row.Header header = this.getHeader(param, attrInfos, propertyName);
                if (header == null) {
                    __logger.info("Could not display param {} as it is not exposed by JMX", new Object[]{param, null});
                    continue;
                }
                headers.add(header);
            }
        }
        return headers;
    }

    protected Row.Header getHeader(String param, MBeanAttributeInfo[] attrInfos, String propertyName) {
        for (MBeanAttributeInfo attrInfo : attrInfos) {
            if (!attrInfo.getName().equals(param)) continue;
            return new Row.Header(param, attrInfo.getDescription(), PrinterUtil.getNote(propertyName, param));
        }
        return null;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public boolean hasOperations() {
        if (this._rows.isEmpty()) {
            return false;
        }
        return this._rows.get(0).getOperations() != null;
    }

    @Override
    public Row get(int index) {
        return this._rows.get(index);
    }

    @Override
    public int size() {
        return this._rows.size();
    }

    @Override
    public void add(int index, Row row) {
        this._rows.add(index, row);
    }

    public List<Row.Header> getHeaders() {
        return this._headers;
    }

    public void setHeaders(List<Row.Header> headers) {
        this._headers = headers;
    }
}

