/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console.data;

import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import org.cipango.console.data.ConsoleLogger;
import org.cipango.console.menu.MenuImpl;

public class SipConsoleLogger
extends ConsoleLogger {
    public static final String CALL_ID_FILTER = "message.callId";
    public static final String BRANCH_FILTER = "message.topVia.branch";
    public static final String TO_FILTER = "message.to.uRI.toString()";
    public static final String FROM_FILTER = "message.from.uRI.toString()";
    public static final String REMOTE_FILTER = "remote";
    public static final String REQUEST_URI_FILTER = "message.requestURI != null and message.requestURI.toString()";
    private SipMessageLog[] _messages;

    public SipConsoleLogger(MBeanServerConnection mbsc, ObjectName objectName, Map<String, String> filters) throws Exception {
        super(mbsc, MenuImpl.SIP_LOGS, objectName, filters);
    }

    @Override
    public String getFilterTitle() {
        String filterValue = this.getMessageFilter().substring(this.getMessageFilter().lastIndexOf(40) + 1);
        filterValue = filterValue.substring(0, filterValue.length() - 1);
        if (this.getMessageFilter().startsWith(CALL_ID_FILTER)) {
            return "Call-ID is " + filterValue;
        }
        if (this.getMessageFilter().startsWith(BRANCH_FILTER)) {
            return "Branch is " + filterValue;
        }
        if (this.getMessageFilter().startsWith(TO_FILTER)) {
            return "To URI is " + filterValue;
        }
        if (this.getMessageFilter().startsWith(FROM_FILTER)) {
            return "From URI is " + filterValue;
        }
        if (this.getMessageFilter().startsWith(REQUEST_URI_FILTER)) {
            return "Request-URI is " + filterValue;
        }
        if (this.getMessageFilter().startsWith(REMOTE_FILTER)) {
            return "Remote host is " + filterValue;
        }
        return this.getMessageFilter();
    }

    public SipMessageLog[] getMessages() {
        return this._messages;
    }

    public void setMessages(Object[][] messagesLogs) {
        this._messages = new SipMessageLog[messagesLogs.length];
        for (int i = 0; i < this._messages.length; ++i) {
            this._messages[i] = new SipMessageLog(messagesLogs[i]);
        }
    }

    public static class SipMessageLog {
        private Object[] _array;

        public SipMessageLog(Object[] array) {
            this._array = array;
        }

        public String getInfoLine() {
            return this._array[0].toString();
        }

        public SipServletMessage getMessage() {
            return (SipServletMessage)this._array[1];
        }

        public String getRemote() {
            return (String)this._array[2];
        }

        public boolean isRequest() {
            return this.getMessage() instanceof SipServletRequest;
        }
    }
}

