/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console.data;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.cipango.console.data.Property;
import org.cipango.console.util.ObjectNameFactory;
import org.cipango.console.util.PrinterUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class PropertyList
extends AbstractList<Property> {
    private static Logger __logger = Log.getLogger(PropertyList.class);
    private List<Property> _properties = new ArrayList<Property>();
    public String _title;

    public PropertyList() {
    }

    public PropertyList(MBeanServerConnection connection, ObjectName objectName, String propertyName) throws Exception {
        this.setTitle(PrinterUtil.getTitle(propertyName));
        this.addProperties(connection, objectName, propertyName);
    }

    public PropertyList(MBeanServerConnection connection, String prefix) throws Exception {
        this.setTitle(PrinterUtil.getTitle(prefix));
        HashMap<String, ObjectName> objectNames = this.getObjectNames(prefix);
        for (Map.Entry<String, ObjectName> entry : objectNames.entrySet()) {
            this.addProperties(connection, entry.getValue(), entry.getKey());
        }
    }

    protected HashMap<String, ObjectName> getObjectNames(String prefix) {
        HashMap<String, ObjectName> objectNames = new HashMap<String, ObjectName>();
        Enumeration<String> enumeration = PrinterUtil.PARAMETERS.getKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            if (!key.startsWith(prefix) || !key.endsWith(".params")) continue;
            String param = key.substring(0, key.lastIndexOf(46));
            String className = param.substring(prefix.length() + 1).toLowerCase();
            Hashtable<String, String> table = new Hashtable<String, String>();
            table.put("type", className.substring(className.lastIndexOf(46) + 1));
            table.put("id", "0");
            ObjectName objectName = ObjectNameFactory.create(className.substring(0, className.lastIndexOf(46)), table);
            objectNames.put(param, objectName);
        }
        return objectNames;
    }

    public void addProperties(MBeanServerConnection connection, ObjectName objectName, String propertyName) throws Exception {
        String[] params = PrinterUtil.getParams(propertyName);
        if (!connection.isRegistered(objectName)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Could not get values for parameters: ");
            for (int i = 0; i < params.length; ++i) {
                sb.append(params[i]);
                if (i + 1 >= params.length) continue;
                sb.append(", ");
            }
            sb.append(" as there are not registered in JMX");
            __logger.warn(sb.toString(), new Object[0]);
        } else {
            MBeanInfo info = connection.getMBeanInfo(objectName);
            MBeanAttributeInfo[] attrInfo = info.getAttributes();
            for (int j = 0; j < params.length; ++j) {
                if (params[j] == null || "".equals(params[j].trim())) continue;
                String name = this.getPropertName(params[j], attrInfo);
                if (name == null) {
                    __logger.warn("Could not found attribute: {} in {}", new Object[]{params[j], objectName});
                    continue;
                }
                String note = PrinterUtil.getNote(propertyName, params[j]);
                Property property = new Property(name, connection.getAttribute(objectName, params[j]), note);
                this.add(property);
            }
        }
    }

    protected String getPropertName(String param, MBeanAttributeInfo[] attrInfo) {
        for (int k = 0; k < attrInfo.length; ++k) {
            if (!attrInfo[k].getName().equals(param)) continue;
            return attrInfo[k].getDescription();
        }
        return null;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public boolean hasNotes() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (!((Property)it.next()).hasNote()) continue;
            return true;
        }
        return false;
    }

    public List<Property> getProperties() {
        return this._properties;
    }

    @Override
    public void add(int index, Property property) {
        this._properties.add(index, property);
    }

    @Override
    public Property get(int index) {
        return this._properties.get(index);
    }

    @Override
    public int size() {
        return this._properties.size();
    }
}

