/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console.data;

import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import org.cipango.console.Action;
import org.cipango.console.Manager;
import org.cipango.console.menu.Page;

public class FileLogger {
    protected MBeanServerConnection _mbsc;
    private boolean _deleteSupported;
    private ObjectName _objectName;
    private Page _page;

    public FileLogger(MBeanServerConnection mbsc, Page page, ObjectName objectName, boolean deleteSupported) throws Exception {
        this._mbsc = mbsc;
        this._page = page;
        this._deleteSupported = deleteSupported;
        this._objectName = objectName;
    }

    public boolean isEnabled() throws Exception {
        return Manager.isRunning(this._mbsc, this._objectName);
    }

    public boolean isRegistered() throws IOException {
        return this._mbsc.isRegistered(this._objectName);
    }

    public String getFilename() throws Exception {
        return (String)this._mbsc.getAttribute(this._objectName, "filename");
    }

    public Integer getRetainDays() throws Exception {
        return (Integer)this._mbsc.getAttribute(this._objectName, "retainDays");
    }

    public boolean isDeletedSupported() {
        return this._deleteSupported;
    }

    public Action getStartAction() {
        return new StartFileLoggerAction(this._page, this._objectName);
    }

    public Action getStopAction() {
        return new StopFileLoggerAction(this._page, this._objectName);
    }

    public Action getDeleteAction() {
        return new DeleteLogsFilesAction(this._page);
    }

    public static class DeleteLogsFilesAction
    extends Action {
        public DeleteLogsFilesAction(Page page) {
            super(page, "delete-logs-files");
        }

        @Override
        protected void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    public static class StopFileLoggerAction
    extends Action.StopAction {
        public StopFileLoggerAction(Page page, ObjectName objectName) {
            super(page, "deactivate-file-message-log", objectName);
        }
    }

    public static class StartFileLoggerAction
    extends Action.StartAction {
        public StartFileLoggerAction(Page page, ObjectName objectName) {
            super(page, "activate-file-message-log", objectName);
        }
    }
}

