/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console.data;

import java.io.IOException;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.servlet.http.HttpServletRequest;
import org.cipango.console.Action;
import org.cipango.console.Manager;
import org.cipango.console.menu.Page;

public class ConsoleLogger {
    public static final int DEFAULT_MAX_MESSAGES = 20;
    private MBeanServerConnection _mbsc;
    private ObjectName _objectName;
    private Page _page;
    private Map<String, String> _filters;
    private int _maxMessages;
    private String _messageFilter = "";
    public static final String CALL_ID_FILTER = "message.callId";
    public static final String BRANCH_FILTER = "message.topVia.branch";
    public static final String TO_FILTER = "message.to.uRI.toString()";
    public static final String FROM_FILTER = "message.from.uRI.toString()";
    public static final String REMOTE_FILTER = "remote";
    public static final String REQUEST_URI_FILTER = "message.requestURI != null and message.requestURI.toString()";

    public ConsoleLogger(MBeanServerConnection mbsc, Page page, ObjectName objectName, Map<String, String> filters) throws Exception {
        this._mbsc = mbsc;
        this._page = page;
        this._objectName = objectName;
        this._filters = filters;
    }

    public boolean isEnabled() throws Exception {
        return Manager.isRunning(this._mbsc, this._objectName);
    }

    public boolean isRegistered() throws IOException {
        return this._mbsc.isRegistered(this._objectName);
    }

    public Map<String, String> getFilters() {
        return this._filters;
    }

    public String getFilterTitle() {
        String filterValue = this._messageFilter.substring(this._messageFilter.lastIndexOf(40) + 1);
        filterValue = filterValue.substring(0, filterValue.length() - 1);
        if (this._messageFilter.startsWith(CALL_ID_FILTER)) {
            return "Call-ID is " + filterValue;
        }
        if (this._messageFilter.startsWith(BRANCH_FILTER)) {
            return "Branch is " + filterValue;
        }
        if (this._messageFilter.startsWith(TO_FILTER)) {
            return "To URI is " + filterValue;
        }
        if (this._messageFilter.startsWith(FROM_FILTER)) {
            return "From URI is " + filterValue;
        }
        if (this._messageFilter.startsWith(REQUEST_URI_FILTER)) {
            return "Request-URI is " + filterValue;
        }
        if (this._messageFilter.startsWith(REMOTE_FILTER)) {
            return "Remote host is " + filterValue;
        }
        return this._messageFilter;
    }

    public int getMaxMessages() {
        return this._maxMessages;
    }

    public void setMaxMessages(int maxMessages) {
        this._maxMessages = maxMessages;
    }

    public String getMessageFilter() {
        return this._messageFilter;
    }

    public void setMessageFilter(String messageFilter) {
        this._messageFilter = messageFilter == null ? "" : messageFilter;
    }

    public Action getStartAction() {
        return new StartConsoleLoggerAction(this._page, this._objectName);
    }

    public Action getStopAction() {
        return new StopConsoleLoggerAction(this._page, this._objectName);
    }

    public Action getClearAction() {
        return new ClearConsoleLoggerAction(this._page);
    }

    public Integer getMaxSavedMessages() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return (Integer)this._mbsc.getAttribute(this._objectName, "maxMessages");
    }

    public static class MessageInMemoryAction
    extends Action {
        private ObjectName _objectName;

        public MessageInMemoryAction(Page page, ObjectName objectName) {
            super(page, "msg-in-memory");
            this._objectName = objectName;
        }

        @Override
        protected void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
            String maxMsg = request.getParameter("maxSavedMessages");
            if (maxMsg != null) {
                mbsc.setAttribute(this._objectName, new Attribute("maxMessages", Integer.parseInt(maxMsg)));
            }
        }
    }

    public static class ClearConsoleLoggerAction
    extends Action {
        public ClearConsoleLoggerAction(Page page) {
            super(page, "clear-logs");
        }

        @Override
        protected void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    public static class StopConsoleLoggerAction
    extends Action.StopAction {
        public StopConsoleLoggerAction(Page page, ObjectName objectName) {
            super(page, "deactivate-console-message-log", objectName);
        }
    }

    public static class StartConsoleLoggerAction
    extends Action.StartAction {
        public StartConsoleLoggerAction(Page page, ObjectName objectName) {
            super(page, "activate-console-message-log", objectName);
        }
    }
}

