/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import javax.management.MBeanServerConnection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.view.VelocityLayoutServlet;
import org.cipango.console.Action;
import org.cipango.console.ApplicationManager;
import org.cipango.console.DiameterManager;
import org.cipango.console.EnvManager;
import org.cipango.console.JettyManager;
import org.cipango.console.JmxConnection;
import org.cipango.console.SipManager;
import org.cipango.console.SnmpManager;
import org.cipango.console.StatisticGraph;
import org.cipango.console.menu.Menu;
import org.cipango.console.menu.MenuFactory;
import org.cipango.console.menu.MenuFactoryImpl;
import org.cipango.console.menu.Page;
import org.cipango.console.util.ReplaceTool;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class VelocityConsoleServlet
extends VelocityLayoutServlet {
    private static final long serialVersionUID = 1L;
    private Logger _logger = Log.getLogger(VelocityConsoleServlet.class);
    private Map<String, List<Action>> _actions = new HashMap<String, List<Action>>();
    private Map<String, JmxConnection> _jmxMap = new HashMap<String, JmxConnection>();
    private Map<String, StatisticGraph> _statisticGraphs = new HashMap<String, StatisticGraph>();
    private JmxConnection.LocalConnection _localConnection;
    private Timer _timer;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._localConnection = new JmxConnection.LocalConnection();
        this._timer = new Timer("Console statistics timer");
        if (this._localConnection.isConnectionValid()) {
            try {
                StatisticGraph statisticGraph = new StatisticGraph(this._localConnection, this._timer);
                statisticGraph.start();
                this._statisticGraphs.put(this._localConnection.getId(), statisticGraph);
            }
            catch (Exception e) {
                this._logger.warn("Failed to start statistic graph", (Throwable)e);
            }
        }
        this._jmxMap.put(this._localConnection.getId(), this._localConnection);
        List<JmxConnection.RmiConnection> rmiConnections = JmxConnection.RmiConnection.getRmiConnections();
        for (JmxConnection.RmiConnection connection : rmiConnections) {
            try {
                this._jmxMap.put(connection.getId(), connection);
                StatisticGraph statisticGraph = new StatisticGraph(connection, this._timer);
                statisticGraph.start();
                this._statisticGraphs.put(connection.getId(), statisticGraph);
            }
            catch (Exception e) {
                this._logger.warn("Unable to add RMI connection: " + connection, (Throwable)e);
            }
        }
        if (this.getServletContext().getAttribute(MenuFactory.class.getName()) == null) {
            this.getServletContext().setAttribute(MenuFactory.class.getName(), (Object)new MenuFactoryImpl());
        }
    }

    public Map<String, Object> newJmxMap(JmxConnection connection) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("replace", new ReplaceTool());
        map.put("connections", this._jmxMap.values());
        map.put("jmxConnection", connection);
        MBeanServerConnection mbsc = connection.getMbsc();
        map.put("envManager", new EnvManager(mbsc));
        map.put("jettyManager", new JettyManager(mbsc));
        map.put("applicationManager", new ApplicationManager(mbsc));
        map.put("sipManager", new SipManager(mbsc));
        map.put("diameterManager", new DiameterManager(mbsc));
        map.put("snmpManager", new SnmpManager(mbsc));
        map.put("statisticGraph", this._statisticGraphs.get(connection.getId()));
        return map;
    }

    protected void doRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String command;
        JmxConnection connection = this.getConnection(request);
        if (!connection.isConnectionValid() && !this._localConnection.isConnectionValid()) {
            response.sendError(503, "JMX is not enabled, unable to use cipango console. Please start Cipango with:\n\tjava -jar start.jar --pre=etc/jetty-jmx.xml");
            return;
        }
        HttpSession session = request.getSession();
        Principal principal = request.getUserPrincipal();
        if (principal != null && !principal.equals(session.getAttribute(Principal.class.getName()))) {
            this._logger.info("User " + principal.getName() + " has logged in console", new Object[0]);
            session.setAttribute(Principal.class.getName(), (Object)principal);
        }
        if ((command = request.getServletPath()).startsWith("/")) {
            command = command.substring(1);
        }
        Menu menu = this.getMenuFactory().getMenu(command, connection.getMbsc());
        request.setAttribute("menu", (Object)menu);
        Page currentPage = menu.getCurrentPage();
        if (currentPage != null && request.getAttribute("fatal") == null) {
            this.registerActions();
            Action action = this.getAction(currentPage, request);
            if (action != null) {
                action.process(request);
                if (action.isAjax(request)) {
                    action.setAjaxContent(request, response);
                } else {
                    response.sendRedirect(request.getRequestURI());
                }
                return;
            }
        }
        super.doRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerActions() {
        List<Action> list = Action.ACTIONS;
        synchronized (list) {
            for (Action action : Action.ACTIONS) {
                this.registerAction(action);
            }
            Action.ACTIONS.clear();
        }
    }

    public void registerAction(Action action) {
        List<Action> list = this._actions.get(action.getPage().getName());
        if (list == null) {
            list = new ArrayList<Action>();
            this._actions.put(action.getPage().getName(), list);
        }
        list.add(action);
    }

    protected Action getAction(Page page, HttpServletRequest request) {
        String param = request.getParameter("action");
        if (param == null || page == null) {
            return null;
        }
        List<Action> list = this._actions.get(page.getName());
        if (list != null) {
            for (Action action : list) {
                if (!action.getParameter().equalsIgnoreCase(param)) continue;
                return action;
            }
        }
        this._logger.warn("No action found for parameter {} and page {}", new Object[]{param, page.getName()});
        return null;
    }

    public JmxConnection getConnection(HttpServletRequest request) {
        JmxConnection connection = null;
        HttpSession session = request.getSession();
        if (request.getAttribute("fatal") != null) {
            return this._localConnection;
        }
        String connectionId = request.getParameter("connection");
        if (connectionId != null && !"".equals(connectionId)) {
            connection = this._jmxMap.get(connectionId);
            if (connection == null) {
                this.fatal(request, "Coud not found RMI connection with ID " + connectionId);
            } else {
                if (connection.isLocal()) {
                    if (session.getAttribute(JmxConnection.class.getName()) != null) {
                        session.setAttribute("info", (Object)"Connected to local JVM");
                    }
                } else {
                    session.setAttribute("info", (Object)("Connected to remote server: " + connection));
                }
                session.setAttribute(JmxConnection.class.getName(), (Object)connection);
            }
        }
        if (connection == null) {
            connection = (JmxConnection)session.getAttribute(JmxConnection.class.getName());
        }
        if (connection == null) {
            if (this._jmxMap.size() > 1) {
                session.setAttribute("info", (Object)"Connected to local JVM");
            }
            connection = this._localConnection;
            session.setAttribute(JmxConnection.class.getName(), (Object)connection);
        }
        try {
            session.setAttribute(MBeanServerConnection.class.getName(), (Object)connection.getMbsc());
        }
        catch (Exception e) {
            this.fatal(request, "Unable to connect to remote server: " + connection);
            connection = this._localConnection;
        }
        return connection;
    }

    public void fatal(HttpServletRequest request, String message) {
        this._logger.warn(message, new Object[0]);
        request.getSession().removeAttribute("info");
        request.setAttribute("fatal", (Object)message);
    }

    protected void fillContext(Context context, HttpServletRequest request) {
        super.fillContext(context, request);
        JmxConnection connection = this.getConnection(request);
        HttpSession session = request.getSession();
        session.setAttribute(StatisticGraph.class.getName(), (Object)this._statisticGraphs.get(connection.getId()));
        if (connection.getContextMap() == null) {
            connection.setContextMap(this.newJmxMap(connection));
        }
        for (Map.Entry<String, Object> entry : connection.getContextMap().entrySet()) {
            context.put(entry.getKey(), entry.getValue());
        }
    }

    public MenuFactory getMenuFactory() {
        return (MenuFactory)this.getServletContext().getAttribute(MenuFactory.class.getName());
    }

    public void destroy() {
        for (StatisticGraph statisticGraph : this._statisticGraphs.values()) {
            statisticGraph.stop();
        }
        this._timer.cancel();
    }

    protected Template getTemplate(HttpServletRequest request, HttpServletResponse response) {
        if (request.getAttribute("fatal") != null) {
            return this.getTemplate("components/Fatal.vm");
        }
        return super.getTemplate(request, response);
    }
}

