/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cipango.console.StatisticGraph;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class StatisticGraphServlet
extends HttpServlet {
    private static final Long ONE_HOUR = new Long(3600L);
    private Logger _logger = Log.getLogger(StatisticGraphServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            Long time;
            StatisticGraph statisticGraph = (StatisticGraph)request.getSession().getAttribute(StatisticGraph.class.getName());
            if (statisticGraph == null) {
                response.sendError(403);
                return;
            }
            response.setContentType("image/png");
            String sTime = request.getParameter("time");
            String type = request.getServletPath().toUpperCase();
            type = type.substring(0, type.length() - 4);
            int index = type.lastIndexOf(47);
            if (index != -1) {
                type = type.substring(index + 1);
            }
            if (sTime == null) {
                time = ONE_HOUR;
            } else {
                try {
                    time = Long.valueOf(sTime);
                }
                catch (NumberFormatException e) {
                    time = ONE_HOUR;
                }
            }
            byte[] image = statisticGraph.createGraphAsPng(time, type);
            response.getOutputStream().write(image);
        }
        catch (Exception e) {
            this._logger.warn("Unable to create graph", (Throwable)e);
        }
    }
}

