/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Date;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.cipango.console.JmxConnection;
import org.cipango.console.SipManager;
import org.cipango.console.util.ObjectNameFactory;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdDefTemplate;
import org.jrobin.core.RrdException;
import org.jrobin.core.Sample;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;
import org.jrobin.graph.RrdGraphDefTemplate;
import org.xml.sax.InputSource;

public class StatisticGraph {
    private static final String RDD_TEMPLATE_FILE_NAME = "rddTemplate.xml";
    private static final ObjectName OPERATING_SYSTEM = ObjectNameFactory.create("java.lang:type=OperatingSystem");
    private static final ObjectName GARBAGE_COLLECTORS = ObjectNameFactory.create("java.lang:type=GarbageCollector,*");
    private static final ObjectName THREAD = ObjectNameFactory.create("java.lang:type=Threading");
    private long _refreshPeriod = -1L;
    private long _timeoutPeriod = 60000L;
    private StatisticGraphTask _task;
    private TimerTask _startTask;
    private RrdDbPool _rrdPool;
    private String _rrdPath;
    private JmxConnection _connection;
    private String _dataFileName;
    private ObjectName _threadPool;
    private Timer _statTimer;
    private Logger _logger = Log.getLogger(StatisticGraph.class);
    private boolean _started = false;
    private boolean _cpuStatAvailable = false;
    private boolean _systemCpuStatAvailable = false;
    private ObjectName[] _contexts;
    private ObjectName[] _sessionManagers;

    public StatisticGraph(JmxConnection connection, Timer timer) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException, RrdException {
        this._connection = connection;
        this._rrdPool = RrdDbPool.getInstance();
        this._statTimer = timer;
    }

    public void setRefreshPeriod(long statRefreshPeriod) {
        if (this._refreshPeriod != statRefreshPeriod) {
            this._refreshPeriod = statRefreshPeriod;
            if (this._task != null) {
                this._task.run();
                this._task.cancel();
            }
            this._task = new StatisticGraphTask();
            if (this._refreshPeriod != -1L) {
                this._statTimer.schedule((TimerTask)this._task, this._refreshPeriod);
            }
        }
    }

    public void reset() {
        try {
            RrdDb rrdDb = this._rrdPool.requestRrdDb(this._rrdPath);
            Sample sample = rrdDb.createSample();
            MBeanServerConnection mbsc = this._connection.getMbsc();
            sample.setValue("sessions", (double)this.getSessions(mbsc));
            MemoryUsage r = this.getMemory().getHeapMemoryUsage();
            sample.setValue("maxMemory", (double)r.getMax());
            sample.setValue("totalMemory", (double)r.getCommitted());
            sample.setValue("usedMemory", (double)r.getUsed());
            sample.update();
            this._rrdPool.release(rrdDb);
        }
        catch (Exception e) {
            this._logger.warn("Unable to reset statistics", (Throwable)e);
        }
    }

    protected long getSessions(MBeanServerConnection mbsc) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        ObjectName[] contexts = new SipManager(mbsc).getContexts();
        if (this.hasContextsChanged(contexts)) {
            boolean valid = true;
            this._logger.debug("SIP Contexts have changed", new Object[0]);
            this._sessionManagers = new ObjectName[contexts.length];
            for (int i = 0; i < contexts.length; ++i) {
                ObjectName sessionHandler;
                if (contexts[i] != null && (sessionHandler = (ObjectName)mbsc.getAttribute(contexts[i], "sessionHandler")) != null) {
                    this._sessionManagers[i] = (ObjectName)mbsc.getAttribute(sessionHandler, "sessionManager");
                }
                if (this._sessionManagers[i] != null) continue;
                this._logger.debug("Could not get session manager for context {}", new Object[]{contexts[i]});
                valid = false;
            }
            if (valid) {
                this._contexts = contexts;
            }
        }
        long sessions = 0L;
        for (ObjectName sessionManager : this._sessionManagers) {
            if (sessionManager == null) continue;
            sessions += ((Long)mbsc.getAttribute(sessionManager, "sessions")).longValue();
        }
        return sessions;
    }

    private boolean hasContextsChanged(ObjectName[] contexts) {
        if (this._contexts == contexts) {
            return false;
        }
        if (this._contexts == null || this._contexts.length != contexts.length) {
            return true;
        }
        for (int i = 0; i < contexts.length; ++i) {
            if (this._contexts[i].equals(contexts[i])) continue;
            return true;
        }
        return false;
    }

    public boolean updateDb() {
        try {
            MBeanServerConnection mbsc;
            try {
                mbsc = this.getMbsc();
            }
            catch (Exception e) {
                return false;
            }
            RrdDb rrdDb = this._rrdPool.requestRrdDb(this._rrdPath);
            Sample sample = rrdDb.createSample();
            sample.setValue("sessions", (double)this.getSessions(mbsc));
            MemoryUsage r = this.getMemory().getHeapMemoryUsage();
            sample.setValue("maxMemory", (double)r.getMax());
            sample.setValue("totalMemory", (double)r.getCommitted());
            sample.setValue("usedMemory", (double)r.getUsed());
            if (mbsc.isRegistered(SipManager.SERVER)) {
                sample.setValue("incomingMessages", (double)((Long)mbsc.getAttribute(SipManager.SERVER, "messagesReceived")).longValue());
                sample.setValue("outgoingMessages", (double)((Long)mbsc.getAttribute(SipManager.SERVER, "messagesSent")).longValue());
            }
            int nbCpu = (Integer)mbsc.getAttribute(OPERATING_SYSTEM, "AvailableProcessors");
            if (this._cpuStatAvailable) {
                long processCpuTime = (Long)mbsc.getAttribute(OPERATING_SYSTEM, "ProcessCpuTime");
                sample.setValue("cpu", (double)(processCpuTime / (long)nbCpu));
                if (this._systemCpuStatAvailable) {
                    sample.setValue("systemCpu", (Double)mbsc.getAttribute(OPERATING_SYSTEM, "SystemCpuLoad") * 100.0);
                }
            }
            long timeInGc = 0L;
            Set<ObjectName> garbageCollections = mbsc.queryNames(GARBAGE_COLLECTORS, null);
            for (ObjectName objectName : garbageCollections) {
                timeInGc += ((Long)mbsc.getAttribute(objectName, "CollectionTime")).longValue();
            }
            sample.setValue("timeInGc", (double)(timeInGc / (long)nbCpu));
            sample.setValue("totalThreads", (double)((Integer)mbsc.getAttribute(THREAD, "ThreadCount")).intValue());
            if (this._threadPool == null) {
                this._threadPool = (ObjectName)this.getMbsc().getAttribute(SipManager.SERVER, "threadPool");
            }
            long threadsInPool = ((Integer)mbsc.getAttribute(this._threadPool, "threads")).intValue();
            sample.setValue("activeThreadsInPool", (double)(threadsInPool - (long)((Integer)mbsc.getAttribute(this._threadPool, "idleThreads")).intValue()));
            sample.setValue("threadsInPool", (double)threadsInPool);
            sample.update();
            this._rrdPool.release(rrdDb);
            return true;
        }
        catch (Exception e) {
            this._logger.warn("Unable to set statistics", (Throwable)e);
            return false;
        }
    }

    public byte[] createGraphAsPng(Date start, Date end, RrdGraphDefTemplate graphTemplate) {
        try {
            RrdDb rrdDb = this._rrdPool.requestRrdDb(this._rrdPath);
            this._rrdPool.release(rrdDb);
            graphTemplate.setVariable("start", start);
            graphTemplate.setVariable("end", end);
            graphTemplate.setVariable("rrd", this._rrdPath);
            RrdGraphDef gDef = graphTemplate.getRrdGraphDef();
            RrdGraph graph = new RrdGraph(gDef);
            return graph.getRrdGraphInfo().getBytes();
        }
        catch (Exception e) {
            this._logger.warn("Unable to create graph", (Throwable)e);
            return null;
        }
    }

    public byte[] createGraphAsPng(long time, String type) {
        long start = System.currentTimeMillis() - time * 1000L;
        long end = System.currentTimeMillis() - 2500L;
        return this.createGraphAsPng(new Date(start), new Date(end), GraphType.valueOf(type.toUpperCase()).getTemplate());
    }

    public void setDataFileName(String name) {
        this._dataFileName = name;
    }

    public synchronized void start() {
        if (this._started) {
            return;
        }
        try {
            this._threadPool = (ObjectName)this.getMbsc().getAttribute(SipManager.SERVER, "threadPool");
            if (this._dataFileName == null) {
                String name = this._connection.isLocal() ? "statistics.rdd" : "statistics-" + this._connection.getId().replace(":", "-") + ".rdd";
                this._dataFileName = System.getProperty("jetty.home", ".") + "/logs/" + name;
            }
            File rrdFile = new File(this._dataFileName);
            this._rrdPath = rrdFile.getAbsolutePath();
            if (this.getMbsc().isRegistered(OPERATING_SYSTEM)) {
                try {
                    this.getMbsc().getAttribute(OPERATING_SYSTEM, "ProcessCpuTime");
                    this._cpuStatAvailable = true;
                    this.getMbsc().getAttribute(OPERATING_SYSTEM, "SystemCpuLoad");
                    this._systemCpuStatAvailable = true;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (!rrdFile.exists()) {
                InputStream templateIs = this.getClass().getResourceAsStream(RDD_TEMPLATE_FILE_NAME);
                RrdDefTemplate defTemplate = new RrdDefTemplate(new InputSource(templateIs));
                defTemplate.setVariable("path", this._rrdPath);
                defTemplate.setVariable("start", new Date(System.currentTimeMillis()));
                RrdDef rrdDef = defTemplate.getRrdDef();
                RrdDb rrdDb = this._rrdPool.requestRrdDb(rrdDef);
                rrdDb.getRrdDef().getStep();
                this._rrdPool.release(rrdDb);
            }
            RrdDb rrdDb = this._rrdPool.requestRrdDb(this._rrdPath);
            this.setRefreshPeriod(rrdDb.getRrdDef().getStep() * 1000L);
            this._rrdPool.release(rrdDb);
            this._started = true;
        }
        catch (Exception e) {
            this._started = false;
            this._logger.warn("Unable to create RRD", (Throwable)e);
            this._startTask = new StartTask();
            this._statTimer.schedule(this._startTask, this._timeoutPeriod);
        }
    }

    public boolean isStarted() {
        return this._started;
    }

    public synchronized void stop() {
        this._started = false;
        if (this._task != null) {
            this._task.cancel();
        }
        if (this._startTask != null) {
            this._startTask.cancel();
        }
        this._refreshPeriod = -1L;
    }

    public MBeanServerConnection getMbsc() {
        return this._connection.getMbsc();
    }

    public MemoryMXBean getMemory() throws IOException {
        return ManagementFactory.newPlatformMXBeanProxy(this.getMbsc(), "java.lang:type=Memory", MemoryMXBean.class);
    }

    class StartTask
    extends TimerTask {
        StartTask() {
        }

        @Override
        public void run() {
            StatisticGraph.this.start();
        }
    }

    class StatisticGraphTask
    extends TimerTask {
        StatisticGraphTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StatisticGraph statisticGraph = StatisticGraph.this;
            synchronized (statisticGraph) {
                boolean success = StatisticGraph.this.updateDb();
                if (StatisticGraph.this._started) {
                    StatisticGraph.this._statTimer.schedule((TimerTask)new StatisticGraphTask(), success ? StatisticGraph.this._refreshPeriod : StatisticGraph.this._timeoutPeriod);
                }
            }
        }
    }

    public static enum GraphType {
        SESSIONS("rddSessionsGraph.xml"),
        MEMORY("rddMemoryGraphTemplate.xml"),
        MESSAGES("rddMessagesGraphTemplate.xml"),
        CPU("rddCpuGraphTemplate.xml"),
        THREADS("rddThreadsGraph.xml");

        private RrdGraphDefTemplate _template;

        private GraphType(String resourceName) {
            try {
                InputStream templateGraph = ((Object)((Object)this)).getClass().getResourceAsStream(resourceName);
                this._template = new RrdGraphDefTemplate(new InputSource(templateGraph));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public RrdGraphDefTemplate getTemplate() {
            return this._template;
        }
    }
}

