/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.servlet.http.HttpServletRequest;
import org.cipango.console.Action;
import org.cipango.console.Manager;
import org.cipango.console.data.ConsoleLogger;
import org.cipango.console.data.FileLogger;
import org.cipango.console.data.Property;
import org.cipango.console.data.PropertyList;
import org.cipango.console.data.Row;
import org.cipango.console.data.SessionIds;
import org.cipango.console.data.SipConsoleLogger;
import org.cipango.console.data.Table;
import org.cipango.console.menu.MenuImpl;
import org.cipango.console.menu.Page;
import org.cipango.console.util.ConsoleUtil;
import org.cipango.console.util.ObjectNameFactory;
import org.cipango.console.util.PrinterUtil;

public class SipManager
extends Manager {
    private static final String[] GET_MSG_SIGNATURE = new String[]{Integer.class.getName(), String.class.getName()};
    public static final ObjectName SERVER = ObjectNameFactory.create("org.cipango.server:type=sipserver,id=0");
    public static final ObjectName CONNECTOR_MANAGER = ObjectNameFactory.create("org.cipango.server:type=connectormanager,id=0");
    public static final ObjectName CONSOLE_LOGGER = ObjectNameFactory.create("org.cipango.callflow:type=jmxmessagelog,id=0");
    public static final ObjectName FILE_MESSAGE_LOG = ObjectNameFactory.create("org.cipango.server.log:type=filemessagelog,id=0");
    public static final ObjectName HANDLER_COLLECTION = ObjectNameFactory.create("org.cipango.server.handler:type=sipcontexthandlercollection,id=0");
    public static final Action CHANGE_TIME_GRAPH = Action.add(new Action(MenuImpl.STATISTICS_GRAPH, "change-time"){

        @Override
        public void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
            String time = request.getParameter("time");
            if (time != null) {
                request.getSession().setAttribute("time", (Object)Integer.parseInt(time));
            }
        }
    });
    public static final Action START_GRAPH = Action.add(new Action(MenuImpl.STATISTICS_GRAPH, "start"){

        @Override
        public void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
            this.getStatisticGraph(request).start();
        }
    });
    public static final Action STOP_GRAPH = Action.add(new Action(MenuImpl.STATISTICS_GRAPH, "stop"){

        @Override
        public void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
            this.getStatisticGraph(request).stop();
        }
    });
    public static final Action RESET_STATS = Action.add(new Action(MenuImpl.STATISTICS_SIP, "reset-statistics"){

        @Override
        public void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
            this.getStatisticGraph(request).reset();
            mbsc.invoke(SERVER, "statsReset", null, null);
        }
    });
    public static final Map<String, String> FILTERS = ConsoleUtil.getFilters(ResourceBundle.getBundle("org.cipango.console.sip-filters"));

    public SipManager(MBeanServerConnection mbsc) {
        super(mbsc);
    }

    public PropertyList getMessageStats() throws Exception {
        return new PropertyList(this._mbsc, "sip.stats.messages");
    }

    public Table getTransactionStats() throws Exception {
        Table table = new Table();
        table.setTitle("Transactions");
        ArrayList<Row.Header> headers = new ArrayList<Row.Header>();
        headers.add(new Row.Header(""));
        headers.add(new Row.Header("Current"));
        headers.add(new Row.Header("Max"));
        headers.add(new Row.Header("Total"));
        table.setHeaders(headers);
        Iterator it = headers.iterator();
        Row row = new Row();
        ObjectName transactionManager = this.getTransactionManager();
        row.getValues().add(new Row.Value("Client transaction", (Row.Header)it.next()));
        row.getValues().add(new Row.Value(this._mbsc.getAttribute(transactionManager, "clientTransactions"), (Row.Header)it.next()));
        row.getValues().add(new Row.Value(this._mbsc.getAttribute(transactionManager, "clientTransactionsMax"), (Row.Header)it.next()));
        row.getValues().add(new Row.Value(this._mbsc.getAttribute(transactionManager, "clientTransactionsTotal"), (Row.Header)it.next()));
        table.add(row);
        it = headers.iterator();
        row = new Row();
        row.getValues().add(new Row.Value("Server transaction", (Row.Header)it.next()));
        row.getValues().add(new Row.Value(this._mbsc.getAttribute(transactionManager, "serverTransactions"), (Row.Header)it.next()));
        row.getValues().add(new Row.Value(this._mbsc.getAttribute(transactionManager, "serverTransactionsMax"), (Row.Header)it.next()));
        row.getValues().add(new Row.Value(this._mbsc.getAttribute(transactionManager, "serverTransactionsTotal"), (Row.Header)it.next()));
        table.add(row);
        return table;
    }

    public Table getAppSessionStats() throws Exception {
        return this.getAppSessionStats("sip.stats.applicationSessions");
    }

    public Table getAppSessionTimeStats() throws Exception {
        return this.getAppSessionStats("sip.stats.applicationSessions.time");
    }

    public ObjectName[] getSessionManagers() throws Exception {
        ObjectName[] contexts = (ObjectName[])this._mbsc.getAttribute(HANDLER_COLLECTION, "sipContexts");
        ObjectName[] sessionManagers = new ObjectName[contexts.length];
        for (int i = 0; i < contexts.length; ++i) {
            ObjectName sessionHandler = (ObjectName)this._mbsc.getAttribute(contexts[i], "sessionHandler");
            sessionManagers[i] = (ObjectName)this._mbsc.getAttribute(sessionHandler, "sessionManager");
        }
        return sessionManagers;
    }

    public ObjectName[] getContexts() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        if (this._mbsc.isRegistered(HANDLER_COLLECTION)) {
            return (ObjectName[])this._mbsc.getAttribute(HANDLER_COLLECTION, "sipContexts");
        }
        ObjectName handler = (ObjectName)this._mbsc.getAttribute(SERVER, "handler");
        if (this._mbsc.isInstanceOf(handler, "org.cipango.server.sipapp.SipAppContext")) {
            return new ObjectName[]{handler};
        }
        return (ObjectName[])this._mbsc.getAttribute(handler, "sipContexts");
    }

    public Table getAppSessionStats(String key) throws Exception {
        ObjectName[] contexts = this.getContexts();
        ObjectName[] sessionManagers = new ObjectName[contexts.length];
        for (int i = 0; i < contexts.length; ++i) {
            ObjectName sessionHandler = (ObjectName)this._mbsc.getAttribute(contexts[i], "sessionHandler");
            sessionManagers[i] = (ObjectName)this._mbsc.getAttribute(sessionHandler, "sessionManager");
        }
        Table table = new Table(this._mbsc, sessionManagers, key){

            @Override
            protected Row.Header getHeader(String param, MBeanAttributeInfo[] attrInfos, String propertyName) {
                if ("name".equals(param)) {
                    return new Row.Header("name", "Name");
                }
                Row.Header header = super.getHeader(param, attrInfos, propertyName);
                for (String s : new String[]{"amount of time session remained valid", "application sessions"}) {
                    int index = header.getName().indexOf(s);
                    if (index == -1) continue;
                    header.setName(header.getName().substring(0, index));
                }
                return header;
            }

            @Override
            protected Row.Value getValue(MBeanServerConnection connection, ObjectName objectName, Row.Header header) throws Exception {
                if ("name".equals(header.getSimpleName())) {
                    return new Row.Value(objectName.getKeyProperty("context"), header);
                }
                Row.Value value = super.getValue(connection, objectName, header);
                if (value.getValue() instanceof Double) {
                    DecimalFormat format = new DecimalFormat();
                    format.setMaximumFractionDigits(2);
                    value.setValue(format.format(value.getValue()));
                }
                return value;
            }
        };
        return table;
    }

    public String getStatsDuration() throws Exception {
        Long start = (Long)this._mbsc.getAttribute(SERVER, "statsStartedAt");
        return PrinterUtil.getDuration(System.currentTimeMillis() - start);
    }

    public Table getConnectorsConfig() throws Exception {
        ObjectName[] connectors = (ObjectName[])this._mbsc.getAttribute(SERVER, "connectors");
        return new Table(this._mbsc, connectors, "sip.connectors");
    }

    public PropertyList getThreadPool() throws Exception {
        ObjectName threadPool = (ObjectName)this._mbsc.getAttribute(SERVER, "threadPool");
        PropertyList properties = new PropertyList(this._mbsc, threadPool, "sip.threadPool");
        for (Property property : properties) {
            String name = property.getName();
            int index = Math.max(name.indexOf("in pool"), name.indexOf("in the pool"));
            if (index == -1) continue;
            property.setName(name.substring(0, index));
        }
        return properties;
    }

    public ObjectName getTransactionManager() throws JMException, IOException {
        return (ObjectName)this._mbsc.getAttribute(SERVER, "transactionManager");
    }

    public PropertyList getTimers() throws Exception {
        return new PropertyList(this._mbsc, this.getTransactionManager(), "sip.timers");
    }

    public FileLogger getFileLogger() throws Exception {
        return new FileLogger(this._mbsc, MenuImpl.SIP_LOGS, FILE_MESSAGE_LOG, true);
    }

    public SipConsoleLogger getConsoleLogger(HttpServletRequest request) throws Exception {
        SipConsoleLogger logger = new SipConsoleLogger(this._mbsc, CONSOLE_LOGGER, FILTERS);
        logger.setMessageFilter(request.getParameter("messageFilter"));
        logger.setMaxMessages(ConsoleUtil.getParamValueAsInt("maxMessages", request, 20));
        if (logger.isRegistered() && logger.isEnabled()) {
            Object[] params = new Object[]{new Integer(logger.getMaxMessages()), logger.getMessageFilter()};
            Object[][] messagesLogs = (Object[][])this._mbsc.invoke(CONSOLE_LOGGER, "getMessages", params, GET_MSG_SIGNATURE);
            logger.setMessages(messagesLogs);
        }
        return logger;
    }

    public List<SessionIds> getApplicationIds() throws Exception {
        ObjectName[] sessionManagers = this.getSessionManagers();
        ArrayList<SessionIds> sessionIds = new ArrayList<SessionIds>(sessionManagers.length);
        for (ObjectName sessionManager : sessionManagers) {
            sessionIds.add(new SessionIds(this._mbsc, sessionManager, "applicationSessionIds"));
        }
        return sessionIds;
    }

    public List<SessionIds> getReplicatedApplicationIds() throws Exception {
        ObjectName[] sessionManagers = this.getSessionManagers();
        ArrayList<SessionIds> sessionIds = new ArrayList<SessionIds>(sessionManagers.length);
        for (ObjectName sessionManager : sessionManagers) {
            if (!sessionManager.getDomain().contains("replication")) continue;
            sessionIds.add(new SessionIds(this._mbsc, sessionManager, "replicatedAppSessionIds"));
        }
        return sessionIds;
    }

    public String getSipApplicationSession(String id, String objectName, boolean replicated) throws Exception {
        ObjectName sessionManager = new ObjectName(objectName);
        if (!this._mbsc.isRegistered(sessionManager)) {
            return "The application with name " + sessionManager.getKeyProperty("context") + " is no more registered";
        }
        return (String)this._mbsc.invoke(sessionManager, replicated ? "viewReplicatedSession" : "viewApplicationSession", new Object[]{id}, new String[]{"java.lang.String"});
    }

    static {
        Action.add(new FileLogger.StopFileLoggerAction((Page)MenuImpl.SIP_LOGS, FILE_MESSAGE_LOG));
        Action.add(new FileLogger.StartFileLoggerAction((Page)MenuImpl.SIP_LOGS, FILE_MESSAGE_LOG));
        Action.add(new FileLogger.DeleteLogsFilesAction(MenuImpl.SIP_LOGS){

            @Override
            public void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
                mbsc.invoke(FILE_MESSAGE_LOG, "deleteLogFiles", null, null);
            }
        });
        Action.add(new ConsoleLogger.StopConsoleLoggerAction((Page)MenuImpl.SIP_LOGS, CONSOLE_LOGGER));
        Action.add(new ConsoleLogger.StartConsoleLoggerAction((Page)MenuImpl.SIP_LOGS, CONSOLE_LOGGER));
        Action.add(new ConsoleLogger.ClearConsoleLoggerAction(MenuImpl.SIP_LOGS){

            @Override
            public void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
                mbsc.invoke(CONSOLE_LOGGER, "clear", null, null);
            }
        });
        Action.add(new ConsoleLogger.MessageInMemoryAction((Page)MenuImpl.SIP_LOGS, CONSOLE_LOGGER));
    }
}

