/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.cipango.console.JettyManager;
import org.cipango.console.SipManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class JmxConnection {
    private String _displayName;
    private String _id;
    protected MBeanServerConnection _mbsc;
    private Logger _logger = Log.getLogger(JmxConnection.class);
    private Map<String, Object> _contextMap;

    public synchronized MBeanServerConnection getMbsc() {
        if (!this.isConnectionValid()) {
            try {
                this.initJmxConnection();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this._mbsc;
    }

    public synchronized boolean isConnectionValid() {
        if (this._mbsc == null) {
            return false;
        }
        try {
            this._mbsc.isRegistered(JettyManager.SERVER);
            return true;
        }
        catch (Exception e) {
            this._logger.info("Need to reinitialize RMI connection", new Object[0]);
            this._mbsc = null;
            this._contextMap = null;
            return false;
        }
    }

    protected abstract void initJmxConnection() throws Exception;

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        if (this._displayName != null) {
            return this._displayName;
        }
        return this._id;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getId() {
        return this._id;
    }

    protected void setId(String id) {
        this._id = id;
    }

    public boolean equals(Object obj) {
        return obj instanceof JmxConnection && this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public Map<String, Object> getContextMap() {
        return this._contextMap;
    }

    public void setContextMap(Map<String, Object> contextMap) {
        this._contextMap = contextMap;
    }

    public abstract boolean isLocal();

    public static class RmiConnection
    extends JmxConnection {
        private static final String RMI_HOST = "cipango.console.rmi.host";
        private static final String RMI_PORT = "cipango.console.rmi.port";
        private static final String RMI_NAME = "cipango.console.rmi.name";
        private int _port;
        private String _host;
        private Map<String, Object> _environment;
        private Logger _logger = Log.getLogger(RmiConnection.class);

        public static List<RmiConnection> getRmiConnections() {
            ArrayList<RmiConnection> l = new ArrayList<RmiConnection>();
            int i = 1;
            while (true) {
                String host = System.getProperty("cipango.console.rmi.host." + i);
                String port = System.getProperty("cipango.console.rmi.port." + i);
                String name = System.getProperty("cipango.console.rmi.name." + i);
                if (host == null || port == null || port.trim().equals("0")) break;
                RmiConnection connection = new RmiConnection(host, port, name, null, null);
                l.add(connection);
                ++i;
            }
            return l;
        }

        public RmiConnection(String host, String sPort, String displayName, String usr, String pwd) {
            this._host = host;
            try {
                this._port = Integer.parseInt(sPort);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid port value: " + sPort + " is not a number");
            }
            if (this._host == null || this._host.equals("")) {
                throw new IllegalArgumentException("The host can not be null");
            }
            if (this._port > 65536 || this._port <= 0) {
                throw new IllegalArgumentException("Invalid port value: should be between 0 and 65536");
            }
            this.setId(this._host + ":" + this._port);
            this.setDisplayName(displayName);
            if (usr != null && pwd != null) {
                String[] credentials = new String[]{usr, pwd};
                this._environment = new HashMap<String, Object>();
                this._environment.put("jmx.remote.credentials", credentials);
            }
        }

        @Override
        protected void initJmxConnection() throws SecurityException, MalformedURLException, IOException {
            this._logger.debug("Try to get MBeanServerConnection for connection " + this.toString(), new Object[0]);
            try {
                if (this._mbsc == null) {
                    JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this._host + ":" + this._port + "/jmxrmi");
                    JMXConnector jmxc = JMXConnectorFactory.connect(url, this._environment);
                    this._mbsc = jmxc.getMBeanServerConnection();
                }
                this._logger.debug("Got MBeanServerConnection " + this._mbsc + " for connection " + this.toString(), new Object[0]);
            }
            catch (SecurityException e) {
                this._logger.warn("Unable to connect to " + this.getId() + " due to invalid login/password: " + e.getMessage(), new Object[0]);
                throw e;
            }
        }

        public String getHost() {
            return this._host;
        }

        public int getPort() {
            return this._port;
        }

        @Override
        public boolean isLocal() {
            return false;
        }
    }

    public static class LocalConnection
    extends JmxConnection {
        private Logger _logger = Log.getLogger(LocalConnection.class);

        public LocalConnection() throws IllegalStateException {
            this.setId("local");
            this.setDisplayName("Local JVM");
            this.initJmxConnection();
        }

        @Override
        protected void initJmxConnection() {
            ArrayList<MBeanServer> l = MBeanServerFactory.findMBeanServer(null);
            for (MBeanServer server : l) {
                if (this._mbsc == null) {
                    this._mbsc = server;
                }
                if (!server.isRegistered(JettyManager.SERVER) && !server.isRegistered(SipManager.SERVER)) continue;
                this._mbsc = server;
                break;
            }
            this._logger.debug("Use MBeanServerConnection {}", new Object[]{this._mbsc, null});
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    }
}

