/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import org.cipango.console.Action;
import org.cipango.console.data.ConsoleLogger;
import org.cipango.console.data.DiameterConsoleLogger;
import org.cipango.console.data.FileLogger;
import org.cipango.console.data.PropertyList;
import org.cipango.console.data.Table;
import org.cipango.console.menu.MenuImpl;
import org.cipango.console.menu.Page;
import org.cipango.console.util.ConsoleUtil;
import org.cipango.console.util.ObjectNameFactory;
import org.cipango.console.util.PrinterUtil;

public class DiameterManager {
    public static final ObjectName NODE = ObjectNameFactory.create("org.cipango.diameter.node:type=node,id=0");
    public static final ObjectName PEERS = ObjectNameFactory.create("org.cipango.diameter.node:type=peer,*");
    public static final ObjectName FILE_LOG = ObjectNameFactory.create("org.cipango.diameter.log:type=filemessagelogger,id=0");
    public static final ObjectName CONSOLE_LOG = ObjectNameFactory.create("org.cipango.callflow.diameter:type=jmxmessagelogger,id=0");
    public static final Action ENABLE_STATS = Action.add(new Action(MenuImpl.STATISTICS_DIAMETER, "enable-statistics"){

        @Override
        public void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
            mbsc.setAttribute(NODE, new Attribute("statsOn", Boolean.TRUE));
        }
    });
    public static final Action DISABLE_STATS = Action.add(new Action(MenuImpl.STATISTICS_DIAMETER, "disable-statistics"){

        @Override
        public void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
            mbsc.setAttribute(NODE, new Attribute("statsOn", Boolean.FALSE));
        }
    });
    public static final Action RESET_STATS = Action.add(new Action(MenuImpl.STATISTICS_DIAMETER, "reset-statistics"){

        @Override
        public void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
            mbsc.invoke(NODE, "statsReset", null, null);
        }
    });
    public static final Map<String, String> FILTERS = ConsoleUtil.getFilters(ResourceBundle.getBundle("org.cipango.console.diameter-filters"));
    private MBeanServerConnection _mbsc;

    public DiameterManager(MBeanServerConnection mbsc) {
        this._mbsc = mbsc;
    }

    public boolean isRegistered() throws IOException {
        return this._mbsc.isRegistered(NODE);
    }

    public PropertyList getNodeConfig() throws Exception {
        return new PropertyList(this._mbsc, NODE, "diameter.node");
    }

    public Table getConnectors() throws Exception {
        ObjectName[] transports = (ObjectName[])this._mbsc.getAttribute(NODE, "connectors");
        return new Table(this._mbsc, transports, "diameter.transport");
    }

    public PropertyList getTimers() throws Exception {
        return new PropertyList(this._mbsc, NODE, "diameter.timers");
    }

    public Table getPeers() throws Exception {
        Set<ObjectName> peers = this._mbsc.queryNames(PEERS, null);
        return new Table(this._mbsc, peers, "diameter.peers");
    }

    public PropertyList getSessionsStats() throws Exception {
        ObjectName objectName = (ObjectName)this._mbsc.getAttribute(NODE, "sessionManager");
        return new PropertyList(this._mbsc, objectName, "diameter.stats.sessions");
    }

    public List<PropertyList> getMessageStats() throws Exception {
        ObjectName[] transports = (ObjectName[])this._mbsc.getAttribute(NODE, "connectors");
        ArrayList<PropertyList> l = new ArrayList<PropertyList>(transports.length);
        for (int i = 0; i < transports.length; ++i) {
            l.add(new PropertyList(this._mbsc, transports[i], "diameter.stats.msg"));
        }
        return l;
    }

    public Table getPendingStats() throws Exception {
        Set<ObjectName> peers = this._mbsc.queryNames(PEERS, null);
        return new Table(this._mbsc, peers, "diameter.stats.pending");
    }

    public String getStatsDuration() throws Exception {
        Long start = (Long)this._mbsc.getAttribute(NODE, "statsStartedAt");
        return PrinterUtil.getDuration(System.currentTimeMillis() - start);
    }

    public boolean isStatsEnabled() throws Exception {
        return (Boolean)this._mbsc.getAttribute(NODE, "statsOn");
    }

    public FileLogger getFileLogger() throws Exception {
        return new FileLogger(this._mbsc, MenuImpl.DIAMETER_LOGS, FILE_LOG, true);
    }

    public DiameterConsoleLogger getConsoleLogger(HttpServletRequest request) throws Exception {
        DiameterConsoleLogger logger = new DiameterConsoleLogger(this._mbsc, CONSOLE_LOG, FILTERS);
        logger.setMessageFilter(request.getParameter("messageFilter"));
        logger.setMaxMessages(ConsoleUtil.getParamValueAsInt("maxMessages", request, 20));
        if (logger.isRegistered() && logger.isEnabled()) {
            Object[] params = new Object[]{new Integer(logger.getMaxMessages()), logger.getMessageFilter()};
            Object[][] messagesLogs = (Object[][])this._mbsc.invoke(CONSOLE_LOG, "getMessages", params, new String[]{Integer.class.getName(), String.class.getName()});
            logger.setMessages(messagesLogs);
        }
        return logger;
    }

    static {
        Action.add(new FileLogger.StopFileLoggerAction((Page)MenuImpl.DIAMETER_LOGS, FILE_LOG));
        Action.add(new FileLogger.StartFileLoggerAction((Page)MenuImpl.DIAMETER_LOGS, FILE_LOG));
        Action.add(new FileLogger.DeleteLogsFilesAction(MenuImpl.DIAMETER_LOGS){

            @Override
            public void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
                mbsc.invoke(FILE_LOG, "deleteLogFiles", null, null);
            }
        });
        Action.add(new ConsoleLogger.StopConsoleLoggerAction((Page)MenuImpl.DIAMETER_LOGS, CONSOLE_LOG));
        Action.add(new ConsoleLogger.StartConsoleLoggerAction((Page)MenuImpl.DIAMETER_LOGS, CONSOLE_LOG));
        Action.add(new ConsoleLogger.ClearConsoleLoggerAction(MenuImpl.DIAMETER_LOGS){

            @Override
            public void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
                mbsc.invoke(CONSOLE_LOG, "clear", null, null);
            }
        });
        Action.add(new ConsoleLogger.MessageInMemoryAction((Page)MenuImpl.DIAMETER_LOGS, CONSOLE_LOG));
    }
}

