/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.cipango.console.ApplicationManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Deployer {
    private static final String JAR_PREFIX = "jar:";
    private static final String JAR_POSTFIX = "!/";
    private MBeanServerConnection _connection;
    private Logger _logger = Log.getLogger(Deployer.class);

    public Deployer(MBeanServerConnection connection) {
        this._connection = connection;
    }

    public boolean undeploy(ObjectName contextHandler) {
        try {
            boolean deleteOk;
            File warFile = this.getWarFile(contextHandler);
            File contextFile = this.getContextFile(contextHandler);
            if (contextFile != null && contextFile.exists()) {
                contextFile.delete();
            }
            if (!(deleteOk = this.deleteAll(warFile))) {
                this._logger.info("Unable to delete application file: {}", new Object[]{warFile, null});
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this._logger.warn("Unable to undeploy context " + contextHandler, (Throwable)e);
            return false;
        }
    }

    private File getContextFile(ObjectName contextHandler) throws Exception {
        String contextPath = (String)this._connection.getAttribute(contextHandler, "contextPath");
        return this.getContextFile(contextPath);
    }

    private File getContextFile(String contextPath) throws Exception {
        String filename = null;
        if (this._connection.isRegistered(ApplicationManager.CONTEXT_DEPLOYER)) {
            filename = (String)this._connection.invoke(ApplicationManager.CONTEXT_DEPLOYER, "getContextFilename", new Object[]{contextPath}, new String[]{String.class.getName()});
        }
        if (filename != null) {
            return new File(filename);
        }
        return null;
    }

    private File getWarFile(ObjectName contextHandler) throws Exception {
        String warPath = (String)this._connection.getAttribute(contextHandler, "war");
        if (warPath.startsWith(JAR_PREFIX)) {
            warPath = warPath.substring(JAR_PREFIX.length());
            int index = warPath.length() - JAR_POSTFIX.length();
            warPath = warPath.substring(0, index);
            return new File(new URI(warPath));
        }
        if (warPath.startsWith("file:")) {
            return new File(new URI(warPath));
        }
        return new File(warPath);
    }

    private boolean deleteAll(File root) {
        boolean success = true;
        if (root.exists()) {
            if (!root.isDirectory()) {
                success = root.delete();
            } else {
                File[] files = root.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return !name.equals(".") && !name.equals("..");
                    }
                });
                for (int i = 0; i < files.length; ++i) {
                    success = this.deleteAll(files[i]) && success;
                }
                success = root.delete() && success;
            }
        }
        return success;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deploy(String name, byte[] sarContent) throws Exception {
        int index = Math.max(name.lastIndexOf("/"), name.lastIndexOf("\\"));
        if (index != -1) {
            name = name.substring(index + 1);
        }
        if (!(name.endsWith(".war") || name.endsWith(".sar") || name.endsWith(".jar"))) {
            throw new IllegalArgumentException("Bad extension in name: " + name + ". Allowed is '.war' and '.sar'");
        }
        this.assertValidArchive(sarContent);
        File deployDir = this.getDeployDir();
        File warFile = new File(deployDir, name);
        if (!deployDir.equals(warFile.getParentFile())) {
            throw new IllegalArgumentException("Invalid deployment: " + name);
        }
        if (warFile.exists()) {
            if (!warFile.canWrite() || !warFile.isFile()) throw new IllegalArgumentException("Deployment  already exist and could not overwrite it");
            this._logger.info("Deployment {} already exist, overwrite it", new Object[]{name, null});
        } else {
            this._logger.info("Create new deployment {}", new Object[]{name, null});
        }
        FileOutputStream os = new FileOutputStream(warFile);
        os.write(sarContent);
        os.close();
        this._logger.debug("Copy file {} successful", new Object[]{name, null});
    }

    private File getDeployDir() throws JMException, IOException {
        if (this._connection.isRegistered(ApplicationManager.SIP_APP_DEPLOYER)) {
            String directory = (String)this._connection.getAttribute(ApplicationManager.SIP_APP_DEPLOYER, "webAppDir");
            return new File(directory);
        }
        return new File(System.getProperty("jetty.home", "."), "sipapps");
    }

    private void assertValidArchive(byte[] sarContent) {
        try {
            JarInputStream is = new JarInputStream(new ByteArrayInputStream(sarContent));
            ZipEntry entry = is.getNextEntry();
            if (entry == null) {
                throw new IllegalArgumentException("Not a JAR archive format");
            }
            do {
                if (entry.isDirectory() || !entry.getName().equals("WEB-INF/sip.xml") && !entry.getName().equals("WEB-INF/web.xml")) continue;
                return;
            } while ((entry = is.getNextEntry()) != null);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Not a JAR archive format: " + e.getMessage());
        }
        throw new IllegalArgumentException("Missing WEB-INF/sip.xml or WEB-INF/web.xml in archive");
    }
}

