/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.cipango.console.Action;
import org.cipango.console.Deployer;
import org.cipango.console.JettyManager;
import org.cipango.console.Manager;
import org.cipango.console.SipManager;
import org.cipango.console.data.Row;
import org.cipango.console.data.Table;
import org.cipango.console.menu.MenuImpl;
import org.cipango.console.util.ObjectNameFactory;
import org.cipango.console.util.PrinterUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ApplicationManager
extends Manager {
    private static Logger __logger = Log.getLogger(ApplicationManager.class);
    public static final ObjectName DAR = ObjectNameFactory.create("org.cipango.dar:type=defaultapplicationrouter,id=0");
    public static final ObjectName CONTEXT_DEPLOYER = ObjectNameFactory.create("org.cipango.deployer:type=contextdeployer,id=0");
    public static final ObjectName SIP_APP_DEPLOYER = ObjectNameFactory.create("org.cipango.deployer:type=sipappdeployer,id=0");
    public static final Action START_APP = Action.add(new Action(MenuImpl.MAPPINGS, "start"){

        @Override
        public void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
            String name = request.getParameter("objectName");
            ObjectName objectName = new ObjectName(name);
            if (ApplicationManager.isContext(objectName, mbsc)) {
                mbsc.invoke(objectName, "start", null, null);
                String path = (String)mbsc.getAttribute(objectName, "contextPath");
                request.getSession().setAttribute("info", (Object)("Application with context path " + path + " sucessfully started"));
            } else {
                request.getSession().setAttribute("warn", (Object)"Could not found application");
            }
        }
    });
    public static final Action STOP_APP = Action.add(new Action(MenuImpl.MAPPINGS, "stop"){

        @Override
        public void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
            String name = request.getParameter("objectName");
            ObjectName objectName = new ObjectName(name);
            if (ApplicationManager.isContext(objectName, mbsc)) {
                mbsc.invoke(objectName, "stop", null, null);
                String path = (String)mbsc.getAttribute(objectName, "contextPath");
                request.getSession().setAttribute("info", (Object)("Application with context path " + path + " sucessfully stopped"));
            } else {
                request.getSession().setAttribute("warn", (Object)"Could not found application");
            }
        }
    });
    public static final Action DEPLOY_APP = Action.add(new Action(MenuImpl.MAPPINGS, "deploy"){

        @Override
        public void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                FileItem item2 = null;
                try {
                    ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
                    List items = upload.parseRequest(request);
                    for (FileItem item2 : items) {
                        if (item2.isFormField()) continue;
                        Deployer deployer = new Deployer(mbsc);
                        deployer.deploy(item2.getName(), item2.get());
                        request.getSession().setAttribute("info", (Object)("Successful request to deploy " + item2.getName()));
                        __logger.info("User " + request.getUserPrincipal() + " requested to deploy application: " + item2.getName(), new Object[0]);
                    }
                }
                catch (Throwable e) {
                    __logger.warn("Unable to deploy " + item2.getName(), e);
                    request.getSession().setAttribute("warn", (Object)("Unable to deploy " + item2.getName() + ": " + e.getMessage()));
                }
            }
        }
    });
    public static final Action UNDEPLOY_APP = Action.add(new Action(MenuImpl.MAPPINGS, "undeploy"){

        @Override
        public void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
            String name = request.getParameter("objectName");
            ObjectName objectName = new ObjectName(name);
            if (ApplicationManager.isContext(objectName, mbsc)) {
                Deployer deployer = new Deployer(mbsc);
                deployer.undeploy(objectName);
                String path = (String)mbsc.getAttribute(objectName, "contextPath");
                request.getSession().setAttribute("info", (Object)("Successfull request to undeploy application " + path));
                __logger.info("User " + request.getUserPrincipal() + " requested to undeploy application " + path, new Object[0]);
            } else {
                request.getSession().setAttribute("warn", (Object)"Could not found application");
            }
        }
    });

    private static boolean isContext(ObjectName objectName, MBeanServerConnection mbsc) throws Exception {
        ObjectName[] contexts;
        for (ObjectName name : contexts = ApplicationManager.getWebAppContexts(mbsc)) {
            if (!name.equals(objectName)) continue;
            return true;
        }
        return false;
    }

    public ApplicationManager(MBeanServerConnection mbsc) {
        super(mbsc);
    }

    public ObjectName[] getSipAppContexts() throws Exception {
        return (ObjectName[])this._mbsc.getAttribute(SipManager.HANDLER_COLLECTION, "sipContexts");
    }

    public static ObjectName[] getWebAppContexts(MBeanServerConnection mbsc) throws Exception {
        return (ObjectName[])mbsc.getAttribute(JettyManager.SERVER, "contexts");
    }

    public Table getSipContexts() throws Exception {
        ObjectName[] sipContexts = this.getSipAppContexts();
        ArrayList<ObjectName> webContexts = new ArrayList<ObjectName>(Arrays.asList(ApplicationManager.getWebAppContexts(this._mbsc)));
        List<String> sipParams = Arrays.asList(PrinterUtil.getParams("appContexts.sip"));
        ArrayList<AppContext> contexts = new ArrayList<AppContext>();
        for (ObjectName sipContext : sipContexts) {
            ObjectName webContext = (ObjectName)this._mbsc.getAttribute(sipContext, "webAppContext");
            contexts.add(new AppContext(sipContext, webContext, this._mbsc, sipParams));
            webContexts.remove(webContext);
        }
        for (ObjectName webContext : webContexts) {
            contexts.add(new AppContext(null, webContext, this._mbsc, sipParams));
        }
        Table table = new Table();
        List<Row.Header> headers = table.getHeaders(this._mbsc, contexts.isEmpty() ? null : ((AppContext)contexts.get(0))._sipAppContext, "appContexts.sip");
        headers.addAll(table.getHeaders(this._mbsc, contexts.isEmpty() ? null : ((AppContext)contexts.get(0))._webAppContext, "appContexts.web"));
        table.setHeaders(headers);
        table.setTitle(PrinterUtil.getTitle("appContexts.web"));
        for (AppContext appContext : contexts) {
            Row row = new Row();
            List<Row.Value> values = row.getValues();
            for (Row.Header header : headers) {
                values.add(new Row.Value(appContext.getAttribute(header.getSimpleName()), header));
            }
            row.setObjectName(appContext._webAppContext);
            table.add(row);
        }
        for (Row row : table) {
            if (this.isRunning(row.getObjectName())) {
                row.addOperation(new Operation(STOP_APP, row.getObjectName(), this._mbsc));
            } else {
                row.addOperation(new Operation(START_APP, row.getObjectName(), this._mbsc));
            }
            row.addOperation(new Operation(UNDEPLOY_APP, row.getObjectName(), this._mbsc));
        }
        return table;
    }

    public ObjectName getWebAppContext(ObjectName sipAppContext) throws Exception {
        return (ObjectName)this._mbsc.getAttribute(sipAppContext, "webAppContext");
    }

    public List<Context> getSipMappings() throws Exception {
        ObjectName[] sipContexts;
        ArrayList<Context> l = new ArrayList<Context>();
        for (ObjectName objectName : sipContexts = this.getSipAppContexts()) {
            Context context = new Context((String)this._mbsc.getAttribute(objectName, "name"));
            context.setAvailable((Boolean)this._mbsc.getAttribute(objectName, "available"));
            ObjectName servletHandler = (ObjectName)this._mbsc.getAttribute(objectName, "servletHandler");
            ObjectName[] sipServletMappings = null;
            if (servletHandler != null) {
                sipServletMappings = (ObjectName[])this._mbsc.getAttribute(servletHandler, "servletMappings");
                if (sipServletMappings != null && sipServletMappings.length != 0) {
                    context.setMappings(new Table(this._mbsc, sipServletMappings, "mappings"));
                } else {
                    ObjectName mainServlet = (ObjectName)this._mbsc.getAttribute(servletHandler, "mainServlet");
                    if (mainServlet != null) {
                        context.setMainServlet((String)this._mbsc.getAttribute(mainServlet, "name"));
                    }
                }
            }
            l.add(context);
        }
        return l;
    }

    public boolean isDarRegistered() throws IOException {
        return this._mbsc.isRegistered(DAR);
    }

    public String getDarUrl() throws Exception {
        return (String)this._mbsc.getAttribute(DAR, "configuration");
    }

    public String getDarDefaultApplication() throws Exception {
        return (String)this._mbsc.getAttribute(DAR, "defaultApplication");
    }

    public Table getDarConfig() throws Exception {
        Table table = new Table();
        table.setTitle("Configuration");
        ArrayList<Row.Header> headers = new ArrayList<Row.Header>();
        headers.add(new Row.Header("Method"));
        headers.add(new Row.Header("Application name"));
        headers.add(new Row.Header("Identity"));
        headers.add(new Row.Header("Routing region"));
        headers.add(new Row.Header("URI"));
        headers.add(new Row.Header("Route modifier"));
        headers.add(new Row.Header("State info"));
        table.setHeaders(headers);
        String config = (String)this._mbsc.getAttribute(DAR, "config");
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        Properties properties = new Properties();
        properties.load(is);
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String method = e.nextElement().toString();
            String infos = properties.get(method).toString().trim();
            int li = infos.indexOf(40);
            while (li >= 0) {
                Row row = new Row();
                List<Row.Value> values = row.getValues();
                Iterator headerIt = headers.iterator();
                int ri = infos.indexOf(41, li);
                if (ri < 0) {
                    throw new ParseException(infos, li);
                }
                values.add(new Row.Value(method, (Row.Header)headerIt.next()));
                String info = infos.substring(li + 1, ri);
                li = infos.indexOf(40, ri);
                InfoIterator it = new InfoIterator(info);
                while (it.hasNext()) {
                    values.add(new Row.Value(it.next(), (Row.Header)headerIt.next()));
                }
                table.add(row);
            }
        }
        return table;
    }

    public static class AppContext {
        private ObjectName _sipAppContext;
        private ObjectName _webAppContext;
        private List<String> _sipAppContextFields;
        private MBeanServerConnection _mbsc;

        public AppContext(ObjectName sipAppContext, ObjectName webAppContext, MBeanServerConnection mbsc, List<String> sipAppContextFields) {
            this._sipAppContext = sipAppContext;
            this._webAppContext = webAppContext;
            this._mbsc = mbsc;
            this._sipAppContextFields = sipAppContextFields;
        }

        public Object getAttribute(String name) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            if (this._sipAppContextFields.contains(name)) {
                if (this._sipAppContext == null) {
                    return "N/A";
                }
                return this._mbsc.getAttribute(this._sipAppContext, name);
            }
            return this._mbsc.getAttribute(this._webAppContext, name);
        }
    }

    public static class Operation {
        private Action _action;
        private ObjectName _objectName;
        private String _applicationName;

        public Operation(Action action, ObjectName objectName, MBeanServerConnection mbsc) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            this._action = action;
            this._objectName = objectName;
            this._applicationName = (String)mbsc.getAttribute(this._objectName, "contextPath");
        }

        public Action getAction() {
            return this._action;
        }

        public ObjectName getObjectName() {
            return this._objectName;
        }

        public String getApplicationName() {
            return this._applicationName;
        }
    }

    public static class Context {
        private String _name;
        private Table _mappings;
        private String _mainServlet;
        private boolean _available;

        public Context(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public Table getMappings() {
            return this._mappings;
        }

        public String getMainServlet() {
            return this._mainServlet;
        }

        public void setMappings(Table mappings) {
            this._mappings = mappings;
        }

        public void setMainServlet(String mainServlet) {
            this._mainServlet = mainServlet;
        }

        public boolean isAvailable() {
            return this._available;
        }

        public void setAvailable(boolean available) {
            this._available = available;
        }
    }

    class InfoIterator
    implements Iterator<String> {
        private String _info;
        private int i;
        private String token;

        public InfoIterator(String info) {
            this._info = info;
        }

        @Override
        public boolean hasNext() {
            int ri;
            int li;
            if (this.token == null && (li = this._info.indexOf(34, this.i)) != -1 && (ri = this._info.indexOf(34, li + 1)) != -1) {
                this.token = this._info.substring(li + 1, ri);
                this.i = ri + 1;
            }
            return this.token != null;
        }

        @Override
        public String next() {
            if (this.hasNext()) {
                String s = this.token;
                this.token = null;
                return s;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

