/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.console;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cipango.console.StatisticGraph;
import org.cipango.console.menu.Page;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class Action {
    private static Logger __logger = Log.getLogger(Action.class);
    public static final List<Action> ACTIONS = new ArrayList<Action>();
    private String _parameter;
    private Page _page;

    public static Action add(Action action) {
        if (!ACTIONS.contains(action)) {
            ACTIONS.add(action);
        }
        return action;
    }

    public static void load(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if ((field.getModifiers() & 8) != 8) continue;
            try {
                if (!Action.class.isAssignableFrom(field.getType())) continue;
                Action action = (Action)field.get(null);
                Action.add(action);
                continue;
            }
            catch (Exception e) {
                __logger.warn((Throwable)e);
            }
        }
    }

    public Action(Page page, String parameter) {
        this._parameter = parameter;
        this._page = page;
    }

    public final void process(HttpServletRequest request) {
        try {
            this.doProcess(request, this.getConnection(request));
            if (request.getSession().getAttribute("info") == null && request.getSession().getAttribute("warn") == null) {
                request.getSession().setAttribute("info", (Object)("Action " + this.getDescription() + " successful"));
            }
        }
        catch (ReflectionException e) {
            Throwable cause = e.getCause();
            request.getSession().setAttribute("warn", (Object)("Unable to " + this.getDescription() + ": " + cause));
        }
        catch (Throwable e) {
            __logger.warn(e.getMessage(), e);
            request.getSession().setAttribute("warn", (Object)("Unable to " + this.getDescription() + ": " + e));
        }
    }

    protected abstract void doProcess(HttpServletRequest var1, MBeanServerConnection var2) throws Exception;

    public MBeanServerConnection getConnection(HttpServletRequest request) {
        return (MBeanServerConnection)request.getSession().getAttribute(MBeanServerConnection.class.getName());
    }

    public StatisticGraph getStatisticGraph(HttpServletRequest request) {
        return (StatisticGraph)request.getSession().getAttribute(StatisticGraph.class.getName());
    }

    public Page getPage() {
        return this._page;
    }

    public String getParameter() {
        return this._parameter;
    }

    public String getDescription() {
        String description = this._parameter.replace('-', ' ');
        return description.substring(0, 1).toUpperCase() + description.substring(1);
    }

    public boolean isAjax(HttpServletRequest request) {
        return request.getParameter("ajax") != null;
    }

    public void setAjaxContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    public String toString() {
        return "Action: " + this.getParameter();
    }

    public static class StopAction
    extends Action {
        private ObjectName _objectName;

        public StopAction(Page page, String parameter, ObjectName objectName) {
            super(page, parameter);
            this._objectName = objectName;
        }

        @Override
        protected void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
            mbsc.invoke(this._objectName, "stop", null, null);
        }
    }

    public static class StartAction
    extends Action {
        private ObjectName _objectName;

        public StartAction(Page page, String parameter, ObjectName objectName) {
            super(page, parameter);
            this._objectName = objectName;
        }

        @Override
        protected void doProcess(HttpServletRequest request, MBeanServerConnection mbsc) throws Exception {
            mbsc.invoke(this._objectName, "start", null, null);
        }
    }
}

