/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.client;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRouter;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.servlet.sip.ar.SipRouteModifier;
import javax.servlet.sip.ar.SipTargetedRequestInfo;
import org.cipango.client.MessageHandler;
import org.cipango.client.SipProfile;
import org.cipango.client.UserAgent;
import org.cipango.server.Server;
import org.cipango.server.SipConnector;
import org.cipango.server.bio.UdpConnector;
import org.cipango.server.handler.SipContextHandlerCollection;
import org.cipango.servlet.SipServletHolder;
import org.cipango.sip.NameAddr;
import org.cipango.sipapp.SipAppContext;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

public class SipClient
extends AbstractLifeCycle {
    private Server _server;
    private SipAppContext _context;
    private List<UserAgent> _userAgents = new ArrayList<UserAgent>();

    public SipClient(String host, int port) {
        this._server = new Server();
        UdpConnector connector = new UdpConnector();
        connector.setHost(host);
        connector.setPort(port);
        this._server.getConnectorManager().addConnector((SipConnector)connector);
        this._server.setApplicationRouter((SipApplicationRouter)new ApplicationRouter());
        SipContextHandlerCollection handler = new SipContextHandlerCollection();
        this._server.setHandler((Handler)handler);
        this._context = new SipAppContext();
        this._context.setConfigurationClasses(new String[0]);
        this._context.setContextPath("/");
        this._context.setName(SipClient.class.getName());
        SipServletHolder holder = new SipServletHolder();
        holder.setServlet((Servlet)new ClientServlet());
        holder.setName(ClientServlet.class.getName());
        this._context.getSipServletHandler().addSipServlet(holder);
        this._context.getSipServletHandler().setMainServletName(ClientServlet.class.getName());
        handler.addHandler((Handler)this._context);
    }

    public SipClient(int port) {
        this(null, port);
    }

    public SipFactory getFactory() {
        return this._context.getSipFactory();
    }

    public UserAgent createUserAgent(SipProfile profile) {
        UserAgent agent = new UserAgent(profile);
        this.addAgent(agent);
        return agent;
    }

    protected void doStart() throws Exception {
        this._server.start();
    }

    protected void doStop() throws Exception {
        this._server.stop();
    }

    public SipURI getContact() {
        return this._server.getConnectorManager().getDefaultConnector().getSipUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserAgent getUserAgent(URI uri) {
        List<UserAgent> list = this._userAgents;
        synchronized (list) {
            for (UserAgent agent : this._userAgents) {
                if (!agent.getProfile().getURI().equals(uri)) continue;
                return agent;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgent(UserAgent agent) {
        SipURI contact = (SipURI)this.getContact().clone();
        agent.setFactory(this._context.getSipFactory());
        agent.setContact((Address)new NameAddr((URI)contact));
        List<UserAgent> list = this._userAgents;
        synchronized (list) {
            this._userAgents.add(agent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ApplicationRouter
    implements SipApplicationRouter {
        ApplicationRouter() {
        }

        public void init() {
        }

        public void init(Properties properties) {
        }

        public void destroy() {
        }

        public void applicationDeployed(List<String> deployedApplications) {
        }

        public void applicationUndeployed(List<String> undeployedApplications) {
        }

        public SipApplicationRouterInfo getNextApplication(SipServletRequest request, SipApplicationRoutingRegion region, SipApplicationRoutingDirective directive, SipTargetedRequestInfo requestedInfo, Serializable info) {
            if (request.getRemoteAddr() == null) {
                return null;
            }
            return new SipApplicationRouterInfo(SipClient.class.getName(), SipApplicationRoutingRegion.NEUTRAL_REGION, request.getFrom().getURI().toString(), null, SipRouteModifier.NO_ROUTE, (Serializable)Integer.valueOf(1));
        }
    }

    class ClientServlet
    extends SipServlet {
        ClientServlet() {
        }

        protected MessageHandler getHandler(SipServletMessage message) {
            return (MessageHandler)message.getSession().getAttribute(MessageHandler.class.getName());
        }

        protected void doRequest(SipServletRequest request) throws ServletException, IOException {
            MessageHandler handler = this.getHandler((SipServletMessage)request);
            if (handler != null) {
                handler.handleRequest(request);
            }
            if (request.isInitial()) {
                Address local = request.getTo();
                UserAgent agent = SipClient.this.getUserAgent(local.getURI());
                if (agent != null) {
                    agent.handleInitialRequest(request);
                } else {
                    this.log("No agent for initial request: " + request.getMethod() + " " + request.getRequestURI());
                }
            } else {
                this.log("No handler for request: " + request.getMethod() + " " + request.getRequestURI());
            }
        }

        protected void doResponse(SipServletResponse response) throws ServletException, IOException {
            MessageHandler handler = this.getHandler((SipServletMessage)response);
            if (handler != null) {
                handler.handleResponse(response);
            } else {
                this.log("No handler for response: " + response.getStatus() + " " + response.getMethod());
            }
        }
    }
}

