/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.cipango.client.Authentication;
import org.cipango.client.Credentials;
import org.cipango.client.MessageHandler;
import org.cipango.sip.NameAddr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Registration {
    private SipURI _uri;
    private SipFactory _factory;
    private SipSession _session;
    private Listener _listener;
    private Credentials _credentials;
    private Authentication _authentication;
    private MessageHandler _handler = new Handler();

    public Registration(SipURI uri) {
        this._uri = uri;
    }

    public void setFactory(SipFactory factory) {
        this._factory = factory;
    }

    public void setCredentials(Credentials credentials) {
        this._credentials = credentials;
    }

    protected SipServletRequest createRegister(URI contact, int expires) {
        SipServletRequest register;
        if (this._session == null) {
            SipApplicationSession appSession = this._factory.createApplicationSession();
            register = this._factory.createRequest(appSession, "REGISTER", (URI)this._uri, (URI)this._uri);
            this._session = register.getSession();
            this._session.setAttribute(MessageHandler.class.getName(), (Object)this._handler);
        } else {
            register = this._session.createRequest("REGISTER");
        }
        SipURI registrar = this._factory.createSipURI(null, this._uri.getHost());
        register.setRequestURI((URI)registrar);
        register.setAddressHeader("Contact", (Address)new NameAddr(contact));
        register.setExpires(expires);
        if (this._authentication != null) {
            try {
                String authorization = this._authentication.authorize(register.getMethod(), register.getRequestURI().toString(), this._credentials);
                register.addHeader("Authorization", authorization);
            }
            catch (ServletException e) {
                e.printStackTrace();
            }
        }
        return register;
    }

    public void register(URI contact, int expires) {
        try {
            this.createRegister(contact, expires).send();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setListener(Listener listener) {
        this._listener = listener;
    }

    protected void registrationDone(Address contact, int expires, List<Address> contacts) {
        if (this._listener != null) {
            this._listener.registrationDone(contact, expires, contacts);
        }
        System.out.println("registered " + contact);
    }

    protected void registrationFailed(int status) {
        if (this._listener != null) {
            this._listener.registrationFailed(status);
        }
    }

    class Handler
    implements MessageHandler {
        Handler() {
        }

        public void handleRequest(SipServletRequest request) throws IOException, ServletException {
            request.createResponse(488).send();
        }

        public void handleResponse(SipServletResponse response) throws IOException, ServletException {
            int status = response.getStatus();
            System.out.println("got response " + status);
            if (status == 200) {
                int expires = -1;
                Address requestContact = response.getRequest().getAddressHeader("Contact");
                ArrayList<Address> contacts = new ArrayList<Address>();
                ListIterator it = response.getAddressHeaders("Contact");
                while (it.hasNext()) {
                    Address contact = (Address)it.next();
                    if (contact.equals(requestContact)) {
                        expires = contact.getExpires();
                    }
                    contacts.add(contact);
                }
                System.out.println("contact :" + expires);
                if (expires != -1) {
                    Registration.this.registrationDone(requestContact, expires, contacts);
                } else {
                    Registration.this.registrationFailed(0);
                }
            } else if (status == 401) {
                if (Registration.this._credentials == null) {
                    Registration.this.registrationFailed(status);
                } else {
                    String authorization = response.getRequest().getHeader("Authorization");
                    String authenticate = response.getHeader("WWW-Authenticate");
                    Authentication.Digest digest = Authentication.getDigest(authenticate);
                    if (authorization != null && !digest.isStale()) {
                        Registration.this.registrationFailed(status);
                    } else {
                        Registration.this._authentication = new Authentication(digest);
                        URI contact = response.getRequest().getAddressHeader("Contact").getURI();
                        Registration.this.register(contact, response.getRequest().getExpires());
                    }
                }
            } else {
                Registration.this.registrationFailed(status);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Listener {
        public void registrationFailed(int var1);

        public void registrationDone(Address var1, int var2, List<Address> var3);
    }
}

