/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.client;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.cipango.client.MessageHandler;

public class Message {
    private SipFactory _factory;
    private SipURI _from;
    private SipURI _to;
    private Listener _listener;
    private MessageHandler _handler = new Handler();

    public Message(SipURI from, SipURI to) {
        this._from = from;
        this._to = to;
    }

    public void setListener(Listener listener) {
        this._listener = listener;
    }

    public void setFactory(SipFactory factory) {
        this._factory = factory;
    }

    protected SipServletRequest createMessage(SipURI from, SipURI to) {
        SipApplicationSession appSession = this._factory.createApplicationSession();
        SipServletRequest message = this._factory.createRequest(appSession, "MESSAGE", (URI)from, (URI)to);
        message.getSession().setAttribute(MessageHandler.class.getName(), (Object)this._handler);
        return message;
    }

    public void send() {
        try {
            this.createMessage(this._from, this._to).send();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class Handler
    implements MessageHandler {
        Handler() {
        }

        public void handleRequest(SipServletRequest request) throws IOException, ServletException {
            request.createResponse(488).send();
        }

        public void handleResponse(SipServletResponse response) throws IOException, ServletException {
            int status = response.getStatus();
            if (Message.this._listener != null) {
                if (status >= 200 && status < 300) {
                    Message.this._listener.messageSucceded();
                } else if (status >= 300) {
                    Message.this._listener.messageFailed();
                }
            }
        }
    }

    public static interface Listener {
        public void messageSucceded();

        public void messageFailed();
    }
}

