/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.client;

import java.security.MessageDigest;
import java.util.Random;
import javax.servlet.ServletException;
import org.cipango.client.Credentials;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.TypeUtil;

public class Authentication {
    private Digest _digest;
    private int _nc = 1;
    private Random _random;
    private static final String[] __padding = new String[]{"0000000", "000000", "00000", "0000", "000", "00", "0"};

    public Authentication(Digest digest) throws ServletException {
        this._digest = digest;
    }

    public String authorize(String method, String uri, Credentials credentials) throws ServletException {
        String cnonce = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(credentials.getUser().getBytes("ISO-8859-1"));
            md.update((byte)58);
            md.update(this._digest._realm.getBytes("ISO-8859-1"));
            md.update((byte)58);
            md.update(credentials.getPasswd().getBytes("ISO-8859-1"));
            byte[] ha1 = md.digest();
            md.reset();
            md.update(method.getBytes("ISO-8859-1"));
            md.update((byte)58);
            md.update(uri.getBytes("ISO-8859-1"));
            byte[] ha2 = md.digest();
            md.reset();
            md.update(TypeUtil.toString((byte[])ha1, (int)16).getBytes("ISO-8859-1"));
            md.update((byte)58);
            md.update(this._digest._nonce.getBytes("ISO-8859-1"));
            md.update((byte)58);
            if (this._digest._qop != null) {
                this._digest._qop = "auth";
                byte[] b = new byte[4];
                if (this._random == null) {
                    this._random = new Random();
                }
                this._random.nextBytes(b);
                cnonce = TypeUtil.toString((byte[])b, (int)16);
                md.update(Authentication.toHex8(this._nc++).getBytes("ISO-8859-1"));
                md.update((byte)58);
                md.update(cnonce.getBytes("ISO-8859-1"));
                md.update((byte)58);
                md.update(this._digest._qop.getBytes("ISO-8859-1"));
                md.update((byte)58);
            }
            md.update(TypeUtil.toString((byte[])ha2, (int)16).getBytes("ISO-8859-1"));
            byte[] response = md.digest();
            String authorize = "Digest username=\"" + credentials.getUser() + "\", nonce=\"" + this._digest._nonce + "\", realm=\"" + this._digest._realm + "\", uri=\"" + uri.toString();
            if (cnonce != null) {
                authorize = authorize + "\", qop=" + this._digest._qop + ", nc=" + Authentication.toHex8(this._nc - 1) + ", cnonce=\"" + cnonce;
            }
            authorize = authorize + "\", response=\"" + TypeUtil.toString((byte[])response, (int)16);
            if (this._digest._opaque != null) {
                authorize = authorize + "\", opaque=\"" + this._digest._opaque;
            }
            authorize = authorize + "\"";
            return authorize;
        }
        catch (Exception e) {
            throw new ServletException("Failed to authorize " + this._digest, (Throwable)e);
        }
    }

    public static String toHex8(int i) {
        String s = Integer.toHexString(i);
        int l = s.length();
        if (l < 8) {
            s = __padding[l - 1] + s;
        }
        return s;
    }

    public static Digest getDigest(String authenticate) throws ServletException {
        Digest digest = new Digest();
        try {
            QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(authenticate, "=, ", true, false);
            String last = null;
            String name = null;
            block7: while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                char c = tok.length() == 1 ? tok.charAt(0) : (char)'\u0000';
                switch (c) {
                    case '=': {
                        name = last;
                        last = tok;
                        continue block7;
                    }
                    case ',': {
                        name = null;
                        continue block7;
                    }
                    case ' ': {
                        continue block7;
                    }
                }
                last = tok;
                if (name == null) continue;
                if ("realm".equalsIgnoreCase(name)) {
                    digest._realm = tok;
                } else if ("qop".equalsIgnoreCase(name)) {
                    digest._qop = tok;
                } else if ("nonce".equalsIgnoreCase(name)) {
                    digest._nonce = tok;
                } else if ("opaque".equalsIgnoreCase(name)) {
                    digest._opaque = tok;
                } else if ("stale".equalsIgnoreCase(name)) {
                    digest._stale = tok;
                }
                name = null;
            }
            return digest;
        }
        catch (Exception e) {
            throw new ServletException("Failed to parse digest: " + authenticate, (Throwable)e);
        }
    }

    static class Digest {
        String _realm;
        String _qop;
        String _nonce;
        String _opaque;
        String _stale;

        Digest() {
        }

        public boolean isStale() {
            return Boolean.parseBoolean(this._stale);
        }

        public String getNonce() {
            return this._nonce;
        }
    }
}

