/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.callflow.diameter;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.cipango.callflow.diameter.JmxMessageLogger;
import org.cipango.diameter.node.DiameterConnection;
import org.cipango.diameter.node.DiameterMessage;

public class MessageInfo {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DiameterMessage _message;
    private JmxMessageLogger.Direction _direction;
    private DiameterConnection _connection;
    private long _date;

    public MessageInfo(DiameterMessage message, JmxMessageLogger.Direction direction, DiameterConnection connection) {
        this._message = message;
        this._direction = direction;
        this._connection = connection;
        this._date = System.currentTimeMillis();
    }

    public long getDate() {
        return this._date;
    }

    public String getFormatedDate() {
        return DATE_FORMAT.format(new Date(this._date));
    }

    public DiameterMessage getMessage() {
        return this._message;
    }

    public JmxMessageLogger.Direction getDirection() {
        return this._direction;
    }

    public DiameterConnection getConnection() {
        return this._connection;
    }

    public String getLocal() {
        return this._connection.getLocalAddr() + ":" + this._connection.getLocalPort();
    }

    public String getRemote() {
        return this._connection.getRemoteAddr() + ":" + this._connection.getRemotePort();
    }

    public long getRelativeTime() {
        return (System.currentTimeMillis() - this._date) / 1000L;
    }
}

