/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.callflow.diameter;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.cipango.callflow.diameter.DiameterMessageFormator;
import org.cipango.callflow.diameter.MessageInfo;
import org.cipango.diameter.Dictionary;
import org.cipango.diameter.base.Accounting;
import org.cipango.diameter.base.Common;
import org.cipango.diameter.ims.Cx;
import org.cipango.diameter.ims.IMS;
import org.cipango.diameter.ims.Sh;
import org.cipango.diameter.io.Codecs;
import org.cipango.diameter.log.DiameterMessageListener;
import org.cipango.diameter.node.DiameterConnection;
import org.cipango.diameter.node.DiameterMessage;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxMessageLogger
extends AbstractLifeCycle
implements DiameterMessageListener {
    private static final int DEFAULT_MAX_MESSAGES = 50;
    private MessageInfo[] _messages;
    private int _maxMessages = 50;
    private int _cursor;

    public int getMaxMessages() {
        return this._maxMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxMessages(int maxMessages) {
        JmxMessageLogger jmxMessageLogger = this;
        synchronized (jmxMessageLogger) {
            if (this.isRunning() && maxMessages != this._maxMessages) {
                MessageInfo[] messages = new MessageInfo[maxMessages];
                ListIterator<MessageInfo> it = this.iterate(false);
                int index = maxMessages;
                while (it.hasPrevious()) {
                    messages[--index] = it.previous();
                    if (index != 0) continue;
                }
                this._cursor = 0;
                this._messages = messages;
            }
            this._maxMessages = maxMessages;
        }
    }

    protected void doStart() throws Exception {
        this._messages = new MessageInfo[this._maxMessages];
        this._cursor = 0;
        super.doStart();
    }

    protected void doStop() throws Exception {
        this._messages = null;
        super.doStop();
    }

    public void messageReceived(DiameterMessage message, DiameterConnection connection) {
        this.doLog(message, Direction.IN, connection);
    }

    public void messageSent(DiameterMessage message, DiameterConnection connection) {
        this.doLog(message, Direction.OUT, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLog(DiameterMessage message, Direction direction, DiameterConnection connection) {
        if (this._messages != null) {
            JmxMessageLogger jmxMessageLogger = this;
            synchronized (jmxMessageLogger) {
                this._messages[this._cursor] = new MessageInfo(message, direction, connection);
                this._cursor = this.getNextCursor();
            }
        }
    }

    public Object[][] getMessages(Integer maxMessages) throws Exception {
        return this.getMessages(maxMessages, null);
    }

    private ListIterator<MessageInfo> iterate(boolean start) {
        return new LogIterator(start);
    }

    private int getNextCursor() {
        return this._cursor + 1 == this._maxMessages ? 0 : this._cursor + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this._messages == null) {
            return;
        }
        JmxMessageLogger jmxMessageLogger = this;
        synchronized (jmxMessageLogger) {
            for (int i = 0; i < this._messages.length; ++i) {
                this._messages[i] = null;
            }
            this._cursor = 0;
        }
    }

    public Object[][] getMessages(Integer maxMessages, String msgFilter) throws Exception {
        List<MessageInfo> messages = this.getMessageList(maxMessages, msgFilter);
        Object[][] tab = new Object[messages.size()][5];
        for (int i = 0; i < tab.length; ++i) {
            MessageInfo info = messages.get(i);
            tab[i][0] = this.generateInfoLine(info);
            DiameterMessageFormator.Output output = DiameterMessageFormator.getPretty().newOutput();
            output.add(info.getMessage());
            tab[i][1] = output.toString();
            tab[i][2] = info.getRemote();
        }
        return tab;
    }

    public String generateInfoLine(MessageInfo messageInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append(messageInfo.getFormatedDate());
        if (messageInfo.getDirection() == Direction.IN) {
            sb.append(" IN  ");
        } else {
            sb.append(" OUT ");
        }
        sb.append(messageInfo.getConnection().getLocalAddr());
        sb.append(':');
        sb.append(messageInfo.getConnection().getLocalPort());
        sb.append(messageInfo.getDirection() == Direction.IN ? " < " : " > ");
        sb.append(messageInfo.getConnection().getRemoteAddr());
        sb.append(':');
        sb.append(messageInfo.getConnection().getRemotePort());
        sb.append('\n');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MessageInfo> getMessageList(Integer maxMessages, String msgFilter) throws Exception {
        if (this._messages == null) {
            return null;
        }
        JmxMessageLogger jmxMessageLogger = this;
        synchronized (jmxMessageLogger) {
            JexlContext jc = JexlHelper.createContext();
            Expression msgExpression = null;
            if (msgFilter != null && !msgFilter.trim().equals("")) {
                Log.debug((String)("Get messages with filter: " + msgFilter));
                msgExpression = ExpressionFactory.createExpression((String)("log." + msgFilter));
            }
            ArrayList<MessageInfo> result = new ArrayList<MessageInfo>();
            ListIterator<MessageInfo> it = this.iterate(false);
            int i = 0;
            while (it.hasPrevious() && i < maxMessages) {
                MessageInfo info = it.previous();
                jc.getVars().put("log", info);
                jc.getVars().put("message", info.getMessage());
                if (msgExpression != null && !((Boolean)msgExpression.evaluate(jc)).booleanValue()) continue;
                result.add(0, info);
                ++i;
            }
            return result;
        }
    }

    public static void main(String[] args) throws Exception {
        Dictionary.getInstance().load(Common.class);
        Dictionary.getInstance().load(Accounting.class);
        Dictionary.getInstance().load(IMS.class);
        Dictionary.getInstance().load(Cx.class);
        Dictionary.getInstance().load(Sh.class);
        JmxMessageLogger logger = new JmxMessageLogger();
        logger.start();
        DiameterMessage message = (DiameterMessage)Codecs.__message.decode(JmxMessageLogger.load("mar.dat"));
        message.getAVPs().add((Object)Cx.CX_APPLICATION_ID.getAVP());
        DiameterMessageFormator.Output output = DiameterMessageFormator.getPretty().newOutput();
        output.add(message);
        System.out.println(output.toString());
    }

    protected static Buffer load(String name) throws Exception {
        URL url = JmxMessageLogger.class.getClassLoader().getResource(name);
        File file = new File(url.toURI());
        FileInputStream fin = new FileInputStream(file);
        byte[] b = new byte[(int)file.length()];
        fin.read(b);
        return new ByteArrayBuffer(b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogIterator
    implements ListIterator<MessageInfo> {
        private int _itCursor;
        private boolean _start = true;

        public LogIterator(boolean start) {
            this._itCursor = start ? (JmxMessageLogger.this._messages[JmxMessageLogger.this.getNextCursor()] == null ? 0 : JmxMessageLogger.this.getNextCursor()) : JmxMessageLogger.this._cursor;
        }

        private int getNextItCursor() {
            return this._itCursor + 1 == JmxMessageLogger.this._maxMessages ? 0 : this._itCursor + 1;
        }

        private int getPreviousItCursor() {
            return this._itCursor == 0 ? JmxMessageLogger.this._maxMessages - 1 : this._itCursor - 1;
        }

        @Override
        public boolean hasNext() {
            return this._itCursor != JmxMessageLogger.this._cursor && JmxMessageLogger.this._messages[this.getNextItCursor()] != null;
        }

        @Override
        public MessageInfo next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next");
            }
            this._itCursor = this.getNextItCursor();
            return JmxMessageLogger.this._messages[this._itCursor];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public void add(MessageInfo arg0) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public boolean hasPrevious() {
            return (this._start || this._itCursor != JmxMessageLogger.this._cursor) && JmxMessageLogger.this._messages[this.getPreviousItCursor()] != null;
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public MessageInfo previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("No previous");
            }
            this._start = false;
            this._itCursor = this.getPreviousItCursor();
            return JmxMessageLogger.this._messages[this._itCursor];
        }

        @Override
        public int previousIndex() {
            return 0;
        }

        @Override
        public void set(MessageInfo arg0) {
            throw new UnsupportedOperationException("Read-only");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        IN,
        OUT;

    }
}

