/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.callflow;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.sip.SipServletRequest;
import org.cipango.server.SipConnection;
import org.cipango.server.SipMessage;
import org.cipango.server.SipResponse;

public class MessageInfo {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SipMessage _sipMessage;
    private int _direction;
    private SipConnection _connection;
    private long _date;

    public MessageInfo(SipMessage message, int direction, SipConnection connection) {
        this._sipMessage = direction == 0 ? (SipMessage)message.clone() : message;
        this._direction = direction;
        this._connection = connection;
        this._date = System.currentTimeMillis();
    }

    public long getDate() {
        return this._date;
    }

    public String getFormatedDate() {
        return DATE_FORMAT.format(new Date(this._date));
    }

    public SipMessage getMessage() {
        return this._sipMessage;
    }

    public int getDirection() {
        return this._direction;
    }

    public SipConnection getConnection() {
        return this._connection;
    }

    public String getLocal() {
        return this._connection.getLocalAddress() + ":" + this._connection.getLocalPort();
    }

    public String getLocalKey() {
        return this._connection.getLocalAddress().getHostAddress() + ":" + this._connection.getLocalPort();
    }

    public String getRemote() {
        return this._connection.getRemoteAddress() + ":" + this._connection.getRemotePort();
    }

    public String getRemoteKey() {
        return this._connection.getRemoteAddress().getHostAddress() + ":" + this._connection.getRemotePort();
    }

    public String getShortName() {
        if (this._sipMessage.isRequest()) {
            return this._sipMessage.getMethod() + " " + ((SipServletRequest)this._sipMessage).getRequestURI();
        }
        SipResponse response = (SipResponse)this._sipMessage;
        return response.getStatus() + " " + response.getReasonPhrase();
    }

    public long getRelativeTime() {
        return (System.currentTimeMillis() - this._date) / 1000L;
    }
}

