/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.callflow;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.cipango.callflow.MessageInfo;
import org.cipango.server.SipConnection;
import org.cipango.server.SipMessage;
import org.cipango.server.log.AbstractMessageLog;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxMessageLog
extends AbstractMessageLog {
    private static final int DEFAULT_MAX_MESSAGES = 50;
    private MessageInfo[] _messages;
    private int _maxMessages = 50;
    private int _cursor;

    public int getMaxMessages() {
        return this._maxMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxMessages(int maxMessages) {
        JmxMessageLog jmxMessageLog = this;
        synchronized (jmxMessageLog) {
            if (this.isRunning() && maxMessages != this._maxMessages) {
                MessageInfo[] messages = new MessageInfo[maxMessages];
                ListIterator<MessageInfo> it = this.iterate(false);
                int index = maxMessages;
                while (it.hasPrevious()) {
                    messages[--index] = it.previous();
                    if (index != 0) continue;
                }
                this._cursor = 0;
                this._messages = messages;
            }
            this._maxMessages = maxMessages;
        }
    }

    protected void doStart() throws Exception {
        this._messages = new MessageInfo[this._maxMessages];
        this._cursor = 0;
        super.doStart();
    }

    protected void doStop() throws Exception {
        this._messages = null;
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLog(SipMessage message, int direction, SipConnection connection) {
        if (this._messages != null) {
            if (direction == 1 && connection.getLocalAddress().equals(connection.getRemoteAddress()) && connection.getLocalPort() == connection.getRemotePort()) {
                return;
            }
            JmxMessageLog jmxMessageLog = this;
            synchronized (jmxMessageLog) {
                this._messages[this._cursor] = new MessageInfo(message, direction, connection);
                this._cursor = this.getNextCursor();
            }
        }
    }

    public Object[][] getMessages(Integer maxMessages) throws Exception {
        return this.getMessages(maxMessages, null);
    }

    private ListIterator<MessageInfo> iterate(boolean start) {
        return new LogIterator(start);
    }

    private int getNextCursor() {
        return this._cursor + 1 == this._maxMessages ? 0 : this._cursor + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this._messages == null) {
            return;
        }
        JmxMessageLog jmxMessageLog = this;
        synchronized (jmxMessageLog) {
            for (int i = 0; i < this._messages.length; ++i) {
                this._messages[i] = null;
            }
            this._cursor = 0;
        }
    }

    public Object[][] getMessages(Integer maxMessages, String msgFilter) throws Exception {
        List<MessageInfo> messages = this.getMessageList(maxMessages, msgFilter);
        Object[][] tab = new Object[messages.size()][3];
        for (int i = 0; i < tab.length; ++i) {
            MessageInfo info = messages.get(i);
            tab[i][0] = this.generateInfoLine(info.getDirection(), info.getConnection(), info.getDate());
            tab[i][1] = info.getMessage();
            tab[i][2] = info.getRemote();
        }
        return tab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MessageInfo> getMessageList(Integer maxMessages, String msgFilter) throws Exception {
        if (this._messages == null) {
            return null;
        }
        JmxMessageLog jmxMessageLog = this;
        synchronized (jmxMessageLog) {
            JexlContext jc = JexlHelper.createContext();
            Expression msgExpression = null;
            if (msgFilter != null && !msgFilter.trim().equals("")) {
                Log.debug((String)("Get messages with filter: " + msgFilter));
                msgExpression = ExpressionFactory.createExpression((String)("log." + msgFilter));
            }
            ArrayList<MessageInfo> result = new ArrayList<MessageInfo>();
            ListIterator<MessageInfo> it = this.iterate(false);
            int i = 0;
            while (it.hasPrevious() && i < maxMessages) {
                MessageInfo info = it.previous();
                jc.getVars().put("log", info);
                jc.getVars().put("message", info.getMessage());
                if (msgExpression != null && !((Boolean)msgExpression.evaluate(jc)).booleanValue()) continue;
                result.add(0, info);
                ++i;
            }
            return result;
        }
    }

    public byte[] generateGraph(Integer maxMessages, String msgFilter, String xslUri) throws Exception {
        return this.generateGraph(this.getMessageList(maxMessages, msgFilter), xslUri, false);
    }

    public byte[] generateGraph(Integer maxMessages, String msgFilter, String xslUri, Boolean includeMsg) throws Exception {
        return this.generateGraph(this.getMessageList(maxMessages, msgFilter), xslUri, includeMsg);
    }

    private byte[] generateGraph(List<MessageInfo> messages, String xslUri, boolean includeMsg) throws IOException {
        MessageInfo info;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStreamWriter out = new OutputStreamWriter(os);
        out.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        if (xslUri != null) {
            out.write("<?xml-stylesheet href=\"" + xslUri + "\" type=\"text/xsl\"?>\n");
        }
        out.write("<data>\n");
        out.write("\t<hosts>\n");
        HashMap<String, Integer> hostsMap = new HashMap<String, Integer>();
        Iterator<MessageInfo> it = messages.iterator();
        int indexLocal = -1;
        int index = 1;
        while (it.hasNext()) {
            info = it.next();
            if (!hostsMap.containsKey(info.getLocalKey())) {
                if (indexLocal == -1) {
                    out.write("\t\t<host>");
                    out.write("Cipango");
                    out.write("</host>\n");
                    indexLocal = index++;
                }
                hostsMap.put(info.getLocalKey(), indexLocal);
            }
            if (hostsMap.containsKey(info.getRemoteKey())) continue;
            out.write("\t\t<host>");
            out.write(info.getRemote());
            out.write("</host>\n");
            hostsMap.put(info.getRemoteKey(), index++);
        }
        out.write("\t</hosts>\n");
        it = messages.iterator();
        out.write("\t<messages>\n");
        while (it.hasNext()) {
            info = it.next();
            out.write("\t\t<message from=\"");
            if (info.getDirection() == 0) {
                out.write(String.valueOf(hostsMap.get(info.getRemoteKey())));
                out.write("\" to=\"");
                out.write(String.valueOf(hostsMap.get(info.getLocalKey())));
                out.write("\">\n");
            } else {
                out.write(String.valueOf(hostsMap.get(info.getLocalKey())));
                out.write("\" to=\"");
                out.write(String.valueOf(hostsMap.get(info.getRemoteKey())));
                out.write("\">\n");
            }
            out.write("\t\t\t<name>");
            out.write(info.getShortName());
            out.write("</name>\n");
            out.write("\t\t\t<date>");
            out.write(info.getFormatedDate());
            out.write("</date>\n");
            if (includeMsg) {
                StringBuilder sb = new StringBuilder(info.getMessage().toString());
                this.replaceAll(sb, "<", "&lt;");
                this.replaceAll(sb, ">", "&gt;");
                String msg = sb.toString();
                int nbLines = 1;
                for (int i = 0; i < msg.length(); ++i) {
                    if (msg.charAt(i) != '\n') continue;
                    ++nbLines;
                }
                out.write("\t\t\t<content nbLines=\"" + nbLines + "\">");
                out.write(msg);
                out.write("</content>\n");
            }
            out.write("\t\t</message>\n");
        }
        out.write("\t</messages>\n");
        out.write("</data>\n");
        out.flush();
        return os.toByteArray();
    }

    private void replaceAll(StringBuilder sb, String toFind, Object toSet) {
        int index = 0;
        while ((index = sb.indexOf(toFind)) != -1) {
            sb.replace(index, index + toFind.length(), toSet.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogIterator
    implements ListIterator<MessageInfo> {
        private int _itCursor;
        private boolean _start = true;

        public LogIterator(boolean start) {
            this._itCursor = start ? (JmxMessageLog.this._messages[JmxMessageLog.this.getNextCursor()] == null ? 0 : JmxMessageLog.this.getNextCursor()) : JmxMessageLog.this._cursor;
        }

        private int getNextItCursor() {
            return this._itCursor + 1 == JmxMessageLog.this._maxMessages ? 0 : this._itCursor + 1;
        }

        private int getPreviousItCursor() {
            return this._itCursor == 0 ? JmxMessageLog.this._maxMessages - 1 : this._itCursor - 1;
        }

        @Override
        public boolean hasNext() {
            return this._itCursor != JmxMessageLog.this._cursor && JmxMessageLog.this._messages[this.getNextItCursor()] != null;
        }

        @Override
        public MessageInfo next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next");
            }
            this._itCursor = this.getNextItCursor();
            return JmxMessageLog.this._messages[this._itCursor];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public void add(MessageInfo arg0) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public boolean hasPrevious() {
            return (this._start || this._itCursor != JmxMessageLog.this._cursor) && JmxMessageLog.this._messages[this.getPreviousItCursor()] != null;
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public MessageInfo previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("No previous");
            }
            this._start = false;
            this._itCursor = this.getPreviousItCursor();
            return JmxMessageLog.this._messages[this._itCursor];
        }

        @Override
        public int previousIndex() {
            return 0;
        }

        @Override
        public void set(MessageInfo arg0) {
            throw new UnsupportedOperationException("Read-only");
        }
    }
}

