/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.annotations;

import java.util.List;
import org.cipango.annotations.SipListenerAnnotation;
import org.eclipse.jetty.annotations.AbstractDiscoverableAnnotationHandler;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppContext;

public class SipListenerAnnotationHandler
extends AbstractDiscoverableAnnotationHandler {
    private static final Logger LOG = Log.getLogger(SipListenerAnnotationHandler.class);

    public SipListenerAnnotationHandler(WebAppContext context) {
        super(context);
    }

    public void handleClass(String className, int version, int access, String signature, String superName, String[] interfaces, String annotation, List<AnnotationParser.Value> values) {
        this.addAnnotation(new SipListenerAnnotation(this._context, className));
    }

    public void handleMethod(String className, String methodName, int access, String desc, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        LOG.warn("@SipListener annotation ignored on method: " + className + "." + methodName + " " + signature, new Object[0]);
    }

    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        LOG.warn("@SipListener annotation not applicable for fields: " + className + "." + fieldName, new Object[0]);
    }

    public String getAnnotationName() {
        return "javax.servlet.sip.annotation.SipListener";
    }
}

