/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.annotations;

import javax.servlet.sip.annotation.SipApplication;
import org.cipango.server.sipapp.SipAppContext;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.WebAppContext;

public class SipApplicationAnnotation
extends DiscoveredAnnotation {
    private static final Logger LOG = Log.getLogger(SipApplicationAnnotation.class);

    public SipApplicationAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    public void apply() {
        Class clazz = this.getTargetClass();
        if (clazz == null) {
            LOG.warn(this._className + " cannot be loaded", new Object[0]);
            return;
        }
        SipApplication annotation = clazz.getAnnotation(SipApplication.class);
        SipAppContext context = (SipAppContext)this._context.getBean(SipAppContext.class);
        if (context.getName() != null && !context.getName().equals(annotation.name())) {
            throw new IllegalStateException("App-name in sip.xml: " + context.getName() + " does not match with SipApplication annotation: " + annotation.name());
        }
        context.getMetaData().setAppName(annotation.name());
        this._context.setDistributable(annotation.distributable());
        this._context.setDisplayName(annotation.displayName());
        context.setProxyTimeout(annotation.proxyTimeout());
        context.getSessionHandler().getSessionManager().setSessionTimeout(annotation.sessionTimeout());
        context.getMetaData().setMainServletName(annotation.mainServlet());
    }
}

