/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.annotations;

import javax.servlet.sip.SipServlet;
import org.cipango.annotations.Util;
import org.cipango.server.servlet.SipServletHolder;
import org.cipango.server.sipapp.SipAppContext;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.WebAppContext;

public class SipServletAnnotation
extends DiscoveredAnnotation {
    private static final Logger LOG = Log.getLogger(SipServletAnnotation.class);

    public SipServletAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    public void apply() {
        Class clazz = this.getTargetClass();
        if (clazz == null) {
            LOG.warn(this._className + " cannot be loaded", new Object[0]);
            return;
        }
        if (!SipServlet.class.isAssignableFrom(clazz)) {
            LOG.warn(clazz.getName() + " is not assignable from javax.servlet.sip.SipServlet", new Object[0]);
            return;
        }
        javax.servlet.sip.annotation.SipServlet annotation = clazz.getAnnotation(javax.servlet.sip.annotation.SipServlet.class);
        String servletName = annotation.name() != null && !"".equals(annotation.name()) ? annotation.name() : this._className.substring(this._className.lastIndexOf(46) + 1);
        SipAppContext context = (SipAppContext)this._context.getBean(SipAppContext.class);
        SipServletHolder holder = context.getServletHandler().getHolder(servletName);
        if (holder == null) {
            holder = new SipServletHolder(Holder.Source.ANNOTATION);
            holder.setName(servletName);
            context.getServletHandler().addServlet(holder);
        }
        if (!Util.isEmpty(annotation.applicationName())) {
            if (context.getName() != null && !context.getName().equals(annotation.applicationName())) {
                throw new IllegalStateException("App-name in sip.xml: " + context.getName() + " does not match with SipApplication annotation: " + annotation.applicationName());
            }
            context.getMetaData().setAppName(annotation.applicationName());
        }
        holder.setInitOrder(annotation.loadOnStartup());
        holder.setDisplayName(annotation.description());
        holder.setClassName(this._className);
    }
}

