/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.annotations;

import java.util.EventListener;
import javax.servlet.sip.annotation.SipListener;
import org.cipango.annotations.Util;
import org.cipango.server.sipapp.SipAppContext;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.WebAppContext;

public class SipListenerAnnotation
extends DiscoveredAnnotation {
    private static final Logger LOG = Log.getLogger(SipListenerAnnotation.class);

    public SipListenerAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    public void apply() {
        Class clazz = this.getTargetClass();
        if (clazz == null) {
            LOG.warn(this._className + " cannot be loaded", new Object[0]);
            return;
        }
        if (!EventListener.class.isAssignableFrom(clazz)) {
            LOG.warn(clazz.getName() + " is not assignable from java.util.EventListener", new Object[0]);
            return;
        }
        SipListener annotation = clazz.getAnnotation(SipListener.class);
        SipAppContext context = (SipAppContext)this._context.getBean(SipAppContext.class);
        if (!Util.isEmpty(annotation.applicationName())) {
            if (context.getName() != null && !context.getName().equals(annotation.applicationName())) {
                throw new IllegalStateException("App-name in sip.xml: " + context.getName() + " does not match with SipApplication annotation: " + annotation.applicationName());
            }
            context.getMetaData().setAppName(annotation.applicationName());
        }
        context.getMetaData().addListener(this._className);
    }
}

